package com.rapid.j2ee.framework.mvc.webservice.text;

import java.io.UnsupportedEncodingException;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.rapid.j2ee.framework.core.exception.ExceptionUtils;
import com.rapid.j2ee.framework.core.utils.ObjectUtils;
import com.rapid.j2ee.framework.core.utils.StreamIoUtils;
import com.rapid.j2ee.framework.core.utils.TypeChecker;
import com.rapid.j2ee.framework.mvc.constants.ViewerType;
import com.rapid.j2ee.framework.mvc.web.context.MvcMethodContext;
import com.rapid.j2ee.framework.mvc.web.text.AbstractMvcMethodContextFormatText;

@Component
public class MvcMethodContextFormatXmlZipText extends
		AbstractMvcMethodContextFormatText<byte[]> {

	public byte[] doResolveMethodContext(MvcMethodContext mvcMethodContext,
			String charset) {

		String value = mvcMethodContextFormatXmlText.resolve(mvcMethodContext,
				charset);

		if (TypeChecker.isEmpty(value)) {
			return ObjectUtils.EMPTY_BYTE_ARRAYS;
		}

		try {
			return StreamIoUtils.zip(value.getBytes(charset));
		} catch (UnsupportedEncodingException e) {
			throw ExceptionUtils.convertThrowableToBaseException(e);
		}
	}

	public ViewerType resolveType() {

		return ViewerType.XmlZip;
	}

	@Autowired
	private MvcMethodContextFormatXmlText mvcMethodContextFormatXmlText;
}
