package com.rapid.j2ee.framework.orm.exportsql;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.util.Assert;

import com.rapid.j2ee.framework.core.io.file.FileWriter;
import com.rapid.j2ee.framework.core.spring.SpringApplicationContextHolder;
import com.rapid.j2ee.framework.core.utils.CollectionsUtil;
import com.rapid.j2ee.framework.core.utils.ObjectUtils;
import com.rapid.j2ee.framework.core.utils.StringUtils;
import com.rapid.j2ee.framework.core.utils.TypeChecker;
import com.rapid.j2ee.framework.orm.exportsql.configurer.ExportSqlConfigurerLoader;
import com.rapid.j2ee.framework.orm.exportsql.configurer.ExportSqlTableDefinitionLoader;
import com.rapid.j2ee.framework.orm.exportsql.naming.ColumnNamingResolver;
import com.rapid.j2ee.framework.orm.medium.table.Table;
import com.rapid.j2ee.framework.orm.medium.table.TableColumn;
import com.rapid.j2ee.framework.orm.utils.SqlParserUtils;

public class ExportSqlQueryRowCallbackHandler implements RowCallbackHandler {

	public ExportSqlQueryRowCallbackHandler(String sql, String[] pkColumnNames,
			FileWriter fileWriter) {

		SpringApplicationContextHolder.inject(this);

		tableName = SqlParserUtils.getSqlTableName(sql);

		this.pkColumnNames = pkColumnNames;

		this.fileWriter = fileWriter;

	}

	public void prepareLoadData() {

		this.loadPrimaryKeyForDeleteSql();
	}

	public void processRow(ResultSet resuletSet) throws SQLException {

		this.loadResultSetMetaDataAndLoadSqlHeader(resuletSet).getColumnCount();

		this.writeDeleteSql(resuletSet);

		this.writeInsertSql(resuletSet);

	}

	private void writeInsertSql(ResultSet resultSet) throws SQLException {

		StringBuffer insertSql = new StringBuffer(this.insertSqlHeader);

		int columnCount = resultSetMetaData.getColumnCount();

		for (int i = 1; i <= columnCount; i++) {

			insertSql.append(this.getResuletSetColumnValueSql(
					getTableColumnByResultSetName(resultSetMetaData
							.getColumnName(i)), resultSet));

			if (i != columnCount) {
				insertSql.append(",");
			}
		}

		insertSql.append(")");

		this.fileWriter.writeln(insertSql.toString() + ";");
	}

	private TableColumn getTableColumnByResultSetName(String name) {

		return CollectionsUtil.findOne(this.exportSqlTableDefinitionLoader
				.getTableByName(this.tableName).getTableColumns(),
				"columnName", name);
	}

	private void writeDeleteSql(ResultSet resultSet) throws SQLException {

		if (TypeChecker.isEmpty(this.tableColumnPks)) {
			return;
		}

		StringBuffer deleteSql = new StringBuffer(this.deleteSqlHeader);

		ColumnNamingResolver columnNamingResolver = exportSqlConfigurerLoader
				.getExportSqlConfigurer().getColumnNamingResolver();

		for (TableColumn tableColumn : tableColumnPks) {

			deleteSql.append(columnNamingResolver.resolve(tableColumn
					.getColumnName()));

			deleteSql.append("=");

			// Value
			deleteSql
					.append(getResuletSetColumnValueSql(tableColumn, resultSet));

			deleteSql.append(" AND ");

		}

		deleteSql.append("1=1");

		fileWriter.writeln(deleteSql.toString() + ";");

	}

	private String getResuletSetColumnValueSql(TableColumn tableColumn,
			ResultSet resultSet) throws SQLException {

		return exportSqlConfigurerLoader.getExportSqlConfigurer()
				.getResultSetFieldValueSqlConverter(
						tableColumn.getColumnType().getOutTypeName()).convert(
						exportSqlConfigurerLoader.getExportSqlConfigurer()
								.getSqlSpecialCharacterHandler(), tableColumn,
						resultSet.getString(tableColumn.getColumnName()));
	}

	private void loadPrimaryKeyForDeleteSql() {

		System.out.println("loadPrimaryKeyForDeleteSql call....");

		tableColumnPks = new ArrayList<TableColumn>();

		Table table = exportSqlTableDefinitionLoader.getTableByName(tableName);

		for (TableColumn column : table.getTableColumns()) {

			if (!isPrimaryKey(column)) {
				continue;
			}

			tableColumnPks.add(column);
		}

		Assert.notEmpty(table.getTableColumns(),
				"Cannot find any table columns under table [" + tableName
						+ "]!");
	}

	private boolean isPrimaryKey(TableColumn column) {

		if (TypeChecker.isEmpty(pkColumnNames)) {
			return column.isPrimaryKey();
		}

		for (String pk : pkColumnNames) {
			if (StringUtils.equalsIgnoreCase(pk, column.getColumnName())) {
				return true;
			}
		}

		return false;
	}

	private ResultSetMetaData loadResultSetMetaDataAndLoadSqlHeader(
			ResultSet resuletSet) throws SQLException {

		if (!TypeChecker.isNull(this.resultSetMetaData)) {
			return this.resultSetMetaData;
		}

		ColumnNamingResolver columnNamingResolver = exportSqlConfigurerLoader
				.getExportSqlConfigurer().getColumnNamingResolver();

		resultSetMetaData = resuletSet.getMetaData();

		insertSqlHeader = "INSERT INTO " + this.tableName + "(";

		int columnCount = resultSetMetaData.getColumnCount();

		for (int i = 1; i <= columnCount; i++) {

			insertSqlHeader = insertSqlHeader
					+ columnNamingResolver.resolve(this.resultSetMetaData
							.getColumnName(i)) + ",";

		}

		insertSqlHeader = StringUtils.substringBeforeLast(insertSqlHeader, ",")
				+ " ) VALUES (";

		deleteSqlHeader = "DELETE FROM " + this.tableName + " WHERE ";

		return this.resultSetMetaData;

	}

	@Autowired
	private ExportSqlTableDefinitionLoader exportSqlTableDefinitionLoader;

	@Autowired
	private ExportSqlConfigurerLoader exportSqlConfigurerLoader;

	private String tableName;

	private String[] pkColumnNames;

	private List<TableColumn> tableColumnPks = ObjectUtils.EMPTY_LIST;

	private FileWriter fileWriter;

	private ResultSetMetaData resultSetMetaData;

	private String insertSqlHeader;

	private String deleteSqlHeader;

}
