package com.rapid.j2ee.framework.orm.exportsql;

import java.beans.BeanInfo;
import java.io.File;
import java.io.OutputStream;
import java.util.List;

import javax.sql.DataSource;

import org.springframework.beans.factory.InitializingBean;
import org.springframework.jdbc.core.JdbcTemplate;

import com.rapid.j2ee.framework.core.charset.Charset;
import com.rapid.j2ee.framework.core.io.file.FileWriter;
import com.rapid.j2ee.framework.core.utils.ObjectUtils;
import com.rapid.j2ee.framework.core.utils.TypeChecker;
import com.rapid.j2ee.framework.orm.exportsql.configurer.ExportSqlConfigurer;
import com.rapid.j2ee.framework.orm.exportsql.configurer.ExportSqlConfigurerLoader;
import com.rapid.j2ee.framework.orm.exportsql.configurer.ExportSqlTableDefinitionLoader;
import com.rapid.j2ee.framework.orm.utils.SqlParserUtils;

public class ExportSqlTemplateGenerator {

	public ExportSqlTemplateGenerator() {

	}

	public void export(String sql, Object[] args, FileWriter writer,
			String... pkColumnNames) {

		ExportSqlQueryRowCallbackHandler exportSqlQueryRowCallbackHandler = new ExportSqlQueryRowCallbackHandler(
				sql, pkColumnNames, writer);

		exportSqlQueryRowCallbackHandler.prepareLoadData();

		jdbcTemplate.query(sql, args, exportSqlQueryRowCallbackHandler);

		writer.flush();

		writer.close();

	}

	public void export(String sql, Object[] args, FileWriter writer) {

		this.export(sql, args, writer, ObjectUtils.EMPTY_STRING_ARRAYS);

	}

	public void export(String sql, Object[] args, String path, Charset charset) {

		FileWriter fileWriter = new FileWriter(new File(path, SqlParserUtils
				.getSqlTableName(sql)
				+ ".sql"), charset);

		this.export(sql, args, fileWriter);

	}

	public void setDataSource(DataSource ds) {
		jdbcTemplate = new JdbcTemplate();
		jdbcTemplate.setDataSource(ds);
	}

	private JdbcTemplate jdbcTemplate;
}
