package com.rapid.j2ee.framework.orm.exportsql.configurer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.util.Assert;

import com.rapid.j2ee.framework.core.io.xml.XPathParser;
import com.rapid.j2ee.framework.core.io.xml.XPathTagBean;
import com.rapid.j2ee.framework.core.reflect.ConstructorUtils;
import com.rapid.j2ee.framework.core.utils.ObjectAnalyzer;
import com.rapid.j2ee.framework.orm.exportsql.convert.ResultSetFieldDateTimeValueSqlConverter;
import com.rapid.j2ee.framework.orm.exportsql.convert.ResultSetFieldNumberValueSqlConverter;
import com.rapid.j2ee.framework.orm.exportsql.convert.ResultSetFieldStringValueSqlConverter;
import com.rapid.j2ee.framework.orm.exportsql.convert.ResultSetFieldValueSqlConverter;
import com.rapid.j2ee.framework.orm.exportsql.naming.AbstractColumnNamingResolver;
import com.rapid.j2ee.framework.orm.exportsql.naming.ColumnNamingResolver;

public class ExportSqlConfigurer {

	private String databaseType;

	private Map<String, ResultSetFieldValueSqlConverter> resultSetFieldValueConverterMap = null;

	@XPathTagBean("configuration/sqlSpecialCharacterHandler")
	private SqlSpecialCharacterHandler sqlSpecialCharacterHandler;

	private ColumnNamingResolver columnNamingResolver;

	@XPathTagBean("configuration/columnMappers/resultSetValueConvert")
	private List<ResultSetValueConvert> resultSetValueConverts = new ArrayList<ResultSetValueConvert>();

	public ExportSqlConfigurer() {

	}

	public void build(XPathParser xParser) {

		this.databaseType = xParser.evalString("configuration/databaseType");

		columnNamingResolver = AbstractColumnNamingResolver
				.getInstanceByDatabaseType(databaseType);

		this.initFieldValueSqlDefaultConverters();

		for (ResultSetValueConvert resuleSetValueConvert : this.resultSetValueConverts) {

			resultSetFieldValueConverterMap.put(
					resuleSetValueConvert.getName(),
					(ResultSetFieldValueSqlConverter) ConstructorUtils
							.newCacheInstance(resuleSetValueConvert.getType()));
		}

		System.out.println("resultSetFieldValueConverterMap =="
				+ resultSetFieldValueConverterMap);

	}

	public ColumnNamingResolver getColumnNamingResolver() {
		return columnNamingResolver;
	}

	public String getDatabaseType() {
		return databaseType;
	}

	public Map<String, ResultSetFieldValueSqlConverter> getResultSetFieldValueConverterMap() {
		return resultSetFieldValueConverterMap;
	}

	public ResultSetFieldValueSqlConverter getResultSetFieldValueSqlConverter(
			String type) {

		if (!resultSetFieldValueConverterMap.containsKey(type)) {
			System.out.println("The type [" + type
					+ "] cannot supported, so use default!!! Keys = "
					+ resultSetFieldValueConverterMap.keySet());

			return resultSetFieldValueConverterMap.get("DEFAULT");
		}

		return resultSetFieldValueConverterMap.get(type);
	}

	public SqlSpecialCharacterHandler getSqlSpecialCharacterHandler() {
		return sqlSpecialCharacterHandler;
	}

	private void initFieldValueSqlDefaultConverters() {

		resultSetFieldValueConverterMap = new HashMap<String, ResultSetFieldValueSqlConverter>();

		ResultSetFieldNumberValueSqlConverter number = new ResultSetFieldNumberValueSqlConverter();

		resultSetFieldValueConverterMap.put("INTEGER", number);
		resultSetFieldValueConverterMap.put("BIGDECIMAL", number);
		resultSetFieldValueConverterMap.put("FLOAT", number);
		resultSetFieldValueConverterMap.put("DOUBLE", number);

		resultSetFieldValueConverterMap.put("TIMESTAMP",
				ResultSetFieldDateTimeValueSqlConverter
						.getInstanceByDatabaseType(databaseType));

		resultSetFieldValueConverterMap.put("DATE",
				ResultSetFieldDateTimeValueSqlConverter
						.getInstanceByDatabaseType(databaseType));

		resultSetFieldValueConverterMap.put("STRING",
				new ResultSetFieldStringValueSqlConverter());

		resultSetFieldValueConverterMap.put("DEFAULT",
				resultSetFieldValueConverterMap.get("STRING"));

	}

	public String toString() {
		return ObjectAnalyzer.toString(this);
	}

}
