package com.rapid.j2ee.framework.orm.exportsql.configurer;

import java.io.IOException;

import org.springframework.beans.factory.InitializingBean;

import com.rapid.j2ee.framework.core.exception.ExceptionUtils;
import com.rapid.j2ee.framework.core.io.xml.XPathParser;
import com.rapid.j2ee.framework.core.io.xml.XmlPaserJavaBean;
import com.rapid.j2ee.framework.core.utils.ObjectAnalyzer;
import com.rapid.j2ee.framework.core.utils.ResourceUtils;
import com.rapid.j2ee.framework.orm.exportsql.naming.AbstractColumnNamingResolver;

public class ExportSqlConfigurerLoader implements InitializingBean {

	public ExportSqlConfigurerLoader() {

	}

	public void afterPropertiesSet() throws Exception {

		this.parser();
	}

	private void parser() {

		try {
			XPathParser xParser = new XPathParser(ResourceUtils.getResource(
					this.exportSqlConfigurePath).getInputStream());

			XmlPaserJavaBean<ExportSqlConfigurer> xmlPaserJavaBean = new XmlPaserJavaBean<ExportSqlConfigurer>(
					xParser, ExportSqlConfigurer.class);

			exportSqlConfigurer = xmlPaserJavaBean.resolve();

			exportSqlConfigurer.build(xParser);

		} catch (IOException e) {
			throw ExceptionUtils.convertThrowableToBaseException(e);
		}
	}

	public ExportSqlConfigurer getExportSqlConfigurer() {
		return exportSqlConfigurer;
	}

	public void setExportSqlConfigurePath(String exportSqlConfigurePath) {
		this.exportSqlConfigurePath = exportSqlConfigurePath;
	}

	public static void main(String[] args) {
		ExportSqlConfigurerLoader loader = new ExportSqlConfigurerLoader();
		loader.parser();
	}

	private ExportSqlConfigurer exportSqlConfigurer;

	private String exportSqlConfigurePath = "export/export_sql_config.xml";

}
