package com.rapid.j2ee.framework.orm.exportsql.configurer;

import java.util.HashMap;
import java.util.Map;

import javax.sql.DataSource;

import org.springframework.beans.factory.InitializingBean;

import com.rapid.j2ee.framework.core.utils.StringUtils;
import com.rapid.j2ee.framework.orm.medium.table.DefaultTableColumnTypeMapper;
import com.rapid.j2ee.framework.orm.medium.table.OracleTableColumnTypeMapper;
import com.rapid.j2ee.framework.orm.medium.table.Table;
import com.rapid.j2ee.framework.orm.medium.table.TableConfigureJdbcTemplate;

public class ExportSqlTableDefinitionLoader implements InitializingBean {

	public ExportSqlTableDefinitionLoader() {

		tableDefinitionMapper = new HashMap<String, Table>();

	}

	public Table getTableByName(String tableName) {

		Table table = tableDefinitionMapper.get(getTableNameAsKey(tableName));

		if (!this.contains(tableName)) {

			table = new Table(schema, tableName);

			table.addTableColumns(tableConfigureJdbcTemplate.getTableColumns(
					catalog, schema, tableName,
					new DefaultTableColumnTypeMapper()));

			tableDefinitionMapper.put(getTableNameAsKey(tableName), table);
		}

		return table;

	}

	public void afterPropertiesSet() throws Exception {
		tableConfigureJdbcTemplate = new TableConfigureJdbcTemplate();
		tableConfigureJdbcTemplate.setDataSource(dataSource);
	}

	public void setDataSource(DataSource dataSource) {
		this.dataSource = dataSource;
	}

	public void setCatalog(String catalog) {
		this.catalog = catalog;
	}

	public void setSchema(String schema) {
		this.schema = schema;
	}

	public boolean contains(String tableName) {

		return tableDefinitionMapper.containsKey(getTableNameAsKey(tableName));
	}

	private String getTableNameAsKey(String tableName) {
		return StringUtils.trimToEmpty(tableName).toUpperCase();
	}

	private TableConfigureJdbcTemplate tableConfigureJdbcTemplate;

	private Map<String, Table> tableDefinitionMapper = null;

	private String catalog;

	private String schema;

	private DataSource dataSource;

}
