package com.rapid.j2ee.framework.orm.exportsql.convert;

import com.rapid.j2ee.framework.core.reflect.ConstructorUtils;
import com.rapid.j2ee.framework.core.utils.StringUtils;
import com.rapid.j2ee.framework.core.utils.TypeChecker;
import com.rapid.j2ee.framework.orm.exportsql.configurer.SqlSpecialCharacterHandler;
import com.rapid.j2ee.framework.orm.exportsql.configurer.SqlSpecialCharacterReplacer;
import com.rapid.j2ee.framework.orm.medium.table.TableColumn;

public abstract class AbstractResultSetFieldValueSqlConverter implements
		ResultSetFieldValueSqlConverter {

	public String convert(
			SqlSpecialCharacterHandler sqlSpecialCharacterHandler,
			TableColumn tableColumn, String value) {

		if (TypeChecker.isNull(value) || this.isNull(value)) {
			return "NULL";
		}

		value = ((SqlSpecialCharacterReplacer) ConstructorUtils
				.newCacheInstance(sqlSpecialCharacterHandler.getHandler()))
				.replace(StringUtils.trimToEmpty(value),
						sqlSpecialCharacterHandler
								.getSqlSpecialCharacterParameters());

		return this.doConvertSql(tableColumn, value);
	}

	protected abstract boolean isNull(String value);

	protected abstract String doConvertSql(TableColumn tableColumn, String value);

}
