package com.rapid.j2ee.framework.orm.exportsql.convert;

import com.rapid.j2ee.framework.core.reflect.ConstructorUtils;
import com.rapid.j2ee.framework.core.utils.NumberUtils;
import com.rapid.j2ee.framework.core.utils.StringUtils;
import com.rapid.j2ee.framework.core.utils.TypeChecker;
import com.rapid.j2ee.framework.orm.medium.table.TableColumn;

public abstract class ResultSetFieldDateTimeValueSqlConverter extends
		AbstractResultSetFieldValueSqlConverter {

	public static ResultSetFieldDateTimeValueSqlConverter getInstanceByDatabaseType(
			String type) {

		type = StringUtils.trimToEmpty(type).toLowerCase();

		return (ResultSetFieldDateTimeValueSqlConverter) ConstructorUtils
				.newCacheInstance(ResultSetFieldDateTimeValueSqlConverter.class
						.getPackage().getName()
						+ "."
						+ StringUtils.upperStartChar(type)
						+ "ResultSetFieldDateTimeValueSqlConverter");
	}

	@Override
	protected String doConvertSql(TableColumn tableColumn, String value) {

		// remove ms
		value = StringUtils.substringBefore(value, ".");

		if (value.indexOf(" ") < 0) {
			value = value + " 00:00:00";
		}

		value = StringUtils.replace(this.getFunction(), "$value", "'" + value
				+ "'");

		value = StringUtils.replace(value, "$format", this.getFormat());

		return value;
	}

	@Override
	protected boolean isNull(String value) {

		return TypeChecker.isEmpty(value);
	}

	public abstract String getFormat();

	public abstract String getFunction();

}
