package com.rapid.j2ee.framework.orm.exportsql.naming;

import com.rapid.j2ee.framework.core.reflect.ConstructorUtils;
import com.rapid.j2ee.framework.core.utils.StringUtils;

public abstract class AbstractColumnNamingResolver implements
		ColumnNamingResolver {

	public static AbstractColumnNamingResolver getInstanceByDatabaseType(
			String databaseType) {

		return (AbstractColumnNamingResolver) ConstructorUtils
				.newCacheInstance(AbstractColumnNamingResolver.class
						.getPackage().getName()
						+ "."
						+ StringUtils.upperStartChar(StringUtils.trimToEmpty(
								databaseType).toLowerCase())
						+ "ColumnNamingResolver");
	}

	public String resolve(String column) {

		return this.getColumnResolveCharacter() + column
				+ this.getColumnResolveCharacter();
	}

	protected abstract String getColumnResolveCharacter();

}
