package com.rapid.j2ee.framework.orm.jdbc;

import java.sql.Connection;
import java.sql.SQLException;

import javax.sql.DataSource;

import org.springframework.jdbc.CannotGetJdbcConnectionException;
import org.springframework.jdbc.support.SQLErrorCodeSQLExceptionTranslator;
import org.springframework.jdbc.support.SQLExceptionTranslator;

public class TransactionSynchronizationManager {

	private static ThreadLocal<Connection> jdbcConnection = new ThreadLocal<Connection>();

	private static ThreadLocal<SQLExceptionTranslator> sqlExceptionTranslator = new ThreadLocal<SQLExceptionTranslator>();

	private static ThreadLocal<Boolean> jdbcConnectionOrginalAutoCommitStatus = new ThreadLocal<Boolean>();

	private TransactionSynchronizationManager() {

	}

	public static void releaseConnection() {

		if (jdbcConnection.get() == null) {
			return;
		}

		try {

			if (jdbcConnectionOrginalAutoCommitStatus.get() != null) {

				jdbcConnection.get().setAutoCommit(
						jdbcConnectionOrginalAutoCommitStatus.get()
								.booleanValue());
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
		System.out
				.println("releaseConnection connection..........................."
						+ jdbcConnection.get());
		try {
			jdbcConnection.get().close();
		} catch (Exception e) {
			e.printStackTrace();
		}
		System.out
				.println("releaseConnection connection..........................."
						+ jdbcConnection.get());

		try {
			jdbcConnection.set(null);
			jdbcConnection.remove();
		} catch (Exception e) {
			e.printStackTrace();
		}

	}

	public static void commit() {
		try {

			jdbcConnection.get().commit();
			System.out
					.println("commit connection........................... con"
							+ jdbcConnection.get());
		} catch (SQLException e) {
			sqlExceptionTranslator.get().translate("Connection Commit", "", e);
		}
	}

	public static void rollback() {
		try {

			jdbcConnection.get().rollback();

		} catch (SQLException e) {
			sqlExceptionTranslator.get().translate("Connection Commit", "", e);
		}
	}

	public static Connection getConnection(DataSource ds) {

		try {
			if (jdbcConnection.get() == null) {

				sqlExceptionTranslator
						.set(new SQLErrorCodeSQLExceptionTranslator(ds));

				Connection con = ds.getConnection();

				System.out
						.println("Get a new connection..........................."
								+ con);

				jdbcConnectionOrginalAutoCommitStatus.set(con.getAutoCommit());

				con.setAutoCommit(false);

				jdbcConnection.set(con);
			}
			return jdbcConnection.get();
		} catch (SQLException e) {
			throw new CannotGetJdbcConnectionException(
					"Could not get JDBC Connection", e);
		}

	}

}
