package com.rapid.j2ee.framework.orm.medium;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.util.Assert;

import com.rapid.j2ee.framework.core.reflect.BeanMergePropertyAcceptor;
import com.rapid.j2ee.framework.core.reflect.BeanUtils;
import com.rapid.j2ee.framework.core.reflect.ConstructorUtils;
import com.rapid.j2ee.framework.core.utils.ObjectUtils;
import com.rapid.j2ee.framework.core.utils.TypeChecker;
import com.rapid.j2ee.framework.orm.medium.filter.UpdateSetColumnFieldFilter;
import com.rapid.j2ee.framework.orm.medium.getter.MediumSessionObjectListByRowCallbackHandler;
import com.rapid.j2ee.framework.orm.medium.getter.MediumSessionResultSetExtractor;
import com.rapid.j2ee.framework.orm.medium.getter.MediumSessionResultSetRowCallbackHandler;
import com.rapid.j2ee.framework.orm.medium.getter.MediumSessionResultSetsExtractor;
import com.rapid.j2ee.framework.orm.medium.interceptor.MediumMapperSqlInterceptor;
import com.rapid.j2ee.framework.orm.medium.interceptor.MediumModelInterceptor;
import com.rapid.j2ee.framework.orm.medium.interceptor.MediumSessionMapperOperationInterceptor;
import com.rapid.j2ee.framework.orm.medium.mapper.PersistentBeanTableDefinitionRegistry;
import com.rapid.j2ee.framework.orm.medium.setter.MediumSessionBatchPreparedStatementSetter;
import com.rapid.j2ee.framework.orm.medium.setter.MediumSessionBatchPreparedStatementSetterImpl;
import com.rapid.j2ee.framework.orm.medium.setter.MediumSessionPreparedStatementPrimaryKeySetter;
import com.rapid.j2ee.framework.orm.medium.setter.MediumSessionPreparedStatementSetter;
import com.rapid.j2ee.framework.orm.medium.setter.MediumSessionPreparedStatementSetterImpl;
import com.rapid.j2ee.framework.orm.medium.sqlinterceptor.MeduimMapperPagerollSQLInterceptor;

public class MediumSessionMapper extends JdbcTemplate implements
		MediumSessionMapperOperations {

	private static final Log LOGGER = LogFactory
			.getLog(MediumSessionMapper.class);

	private MediumSessionMapperOperationInterceptor mediumSessionMapperInterceptor = MediumSessionMapperOperationInterceptor.DEFAULT_INTERCEPTOR;

	public MediumSessionMapper() {

	}

	public Object merge(Object bean) {
		return merge(bean, BeanUtils.BEAN_MERGEPROPERTY_NULLVOID_ACCEPTOR);
	}

	public List mergeList(List records) {
		return mergeList(records,
				BeanUtils.BEAN_MERGEPROPERTY_NULLVOID_ACCEPTOR);
	}

	public List mergeList(List records, BeanMergePropertyAcceptor mergeAcceptor) {

		if (TypeChecker.isEmpty(records)) {
			return records;
		}

		for (Object record : records) {

			this.merge(record, mergeAcceptor);
		}

		return records;
	}

	public Object merge(Object bean, BeanMergePropertyAcceptor mergeAcceptor) {

		if (setObjectPrimaryKeyValues(bean)) {

			this.insert(bean);

			return bean;
		}

		if (!exists(bean)) {

			this.insert(bean);

			return bean;
		}

		Object persistentBean = this.find(bean);

		BeanUtils.merge(bean, persistentBean, mergeAcceptor);

		this.update(persistentBean);

		return bean;

	}

	public Object mergeNotUpdate(Object bean) {
		return this.mergeNotUpdate(bean,
				BeanUtils.BEAN_MERGEPROPERTY_NULLVOID_ACCEPTOR);
	}

	public Object mergeNotUpdate(Object bean,
			BeanMergePropertyAcceptor mergeAcceptor) {

		if (setObjectPrimaryKeyValues(bean)) {

			return bean;
		}

		if (!exists(bean)) {

			return bean;
		}

		Object persistentBean = this.find(bean);

		BeanUtils.merge(bean, persistentBean, mergeAcceptor);

		return persistentBean;

	}

	public Object saveOrUpdate(Object bean) {

		if (setObjectPrimaryKeyValues(bean)) {

			this.insert(bean);

			return bean;
		}

		if (!exists(bean)) {

			this.insert(bean);

			return bean;
		}

		this.merge(bean);

		return bean;

	}

	public boolean setObjectPrimaryKeyValues(Object bean) {

		MediumSessionPreparedStatementSetter callback = new MediumSessionPreparedStatementSetterImpl(
				bean, MediumSessionOperations.SEARTH_COUNTS_BY_PK);

		if (!callback.containPrimaryKeyValues()) {

			callback.setAutowirePrimaryKeyValues();

			return true;
		}

		return false;
	}

	public List insertList(List records) {

		if (TypeChecker.isEmpty(records)) {
			return records;
		}

		MediumSessionBatchPreparedStatementSetter callback = new MediumSessionBatchPreparedStatementSetterImpl(
				this.mediumSessionMapperInterceptor, records, records.get(0)
						.getClass(), MediumSessionOperations.INSERT);

		LOGGER.info("Exists SQL:" + callback.getExecutedSQL());

		super.batchUpdate(callback.getExecutedSQL(), callback);

		return records;
	}

	public boolean exists(Object bean) {

		Assert.notNull(bean, "Must provide persistent bean!");

		MediumSessionPreparedStatementSetter callback = new MediumSessionPreparedStatementSetterImpl(
				bean, MediumSessionOperations.SEARTH_COUNTS_BY_PK);

		if (!callback.containPrimaryKeyValues()) {
			return false;
		}

		LOGGER.info("Exists SQL:" + callback.getExecutedSQL());

		int counts = super.query(callback.getExecutedSQL(), callback,
				new ResultSetExtractor<Integer>() {

					public Integer extractData(ResultSet rs)
							throws SQLException, DataAccessException {

						rs.next();

						return rs.getInt(1);
					}
				});

		return counts > 0;
	}

	public boolean exists(Class clz, final String primaryKey) {

		LOGGER.info(" exists(Class clz, final String primaryKey) primaryKey =:"
				+ primaryKey);

		if (TypeChecker.isEmpty(primaryKey)) {
			return false;
		}

		MediumSessionPreparedStatementSetter callback = new MediumSessionPreparedStatementPrimaryKeySetter(
				MediumSessionOperations.SEARTH_COUNTS_BY_PK, clz, primaryKey);

		LOGGER.info("Exists SQL:" + callback.getExecutedSQL());

		int counts = super.query(callback.getExecutedSQL(), callback,
				new ResultSetExtractor<Integer>() {

					public Integer extractData(ResultSet rs)
							throws SQLException, DataAccessException {

						rs.next();

						return rs.getInt(1);
					}
				});

		return counts > 0;
	}

	public boolean exists(Class clz, final int primaryKey) {

		LOGGER.info(" exists(Class clz, final String primaryKey) primaryKey =:"
				+ primaryKey);

		MediumSessionPreparedStatementSetter callback = new MediumSessionPreparedStatementPrimaryKeySetter(
				MediumSessionOperations.SEARTH_COUNTS_BY_PK, clz, primaryKey);

		LOGGER.info("Exists SQL:" + callback.getExecutedSQL());

		int counts = super.query(callback.getExecutedSQL(), callback,
				new ResultSetExtractor<Integer>() {

					public Integer extractData(ResultSet rs)
							throws SQLException, DataAccessException {

						rs.next();

						return rs.getInt(1);
					}
				});

		return counts > 0;
	}

	public boolean exists(Class clz, final long primaryKey) {

		LOGGER.info(" exists(Class clz, final String primaryKey) primaryKey =:"
				+ primaryKey);

		MediumSessionPreparedStatementSetter callback = new MediumSessionPreparedStatementPrimaryKeySetter(
				MediumSessionOperations.SEARTH_COUNTS_BY_PK, clz, primaryKey);

		LOGGER.info("Exists SQL:" + callback.getExecutedSQL());

		int counts = super.query(callback.getExecutedSQL(), callback,
				new ResultSetExtractor<Integer>() {

					public Integer extractData(ResultSet rs)
							throws SQLException, DataAccessException {

						rs.next();

						return rs.getInt(1);
					}
				});

		return counts > 0;
	}

	public int insert(Object bean) {

		if (TypeChecker.isNull(bean)) {
			return 1;
		}

		this.mediumSessionMapperInterceptor.before("insert", bean);

		setObjectPrimaryKeyValues(bean);

		if (bean instanceof MediumModelInterceptor) {
			((MediumModelInterceptor) bean).before("insert");
		}

		PersistentBeanTableDefinitionRegistry.getInstance()
				.getPersistentBeanTableDefinition(bean.getClass())
				.invokeBeforeInsert(bean);

		int result = updateExecute(bean, MediumSessionOperations.INSERT);

		if (bean instanceof MediumModelInterceptor) {
			((MediumModelInterceptor) bean).after("insert", result);
		}

		return result;
	}

	public int[] updateList(List beans) {

		if (TypeChecker.isEmpty(beans)) {
			return ObjectUtils.EMPTY_INT_ARRAYS;
		}
		int[] effectedRows = new int[beans.size()];
		int index = 0;

		for (Object bean : beans) {
			effectedRows[index++] = this.update(bean);
		}

		return effectedRows;
	}

	public int update(Object bean) {

		UpdateSetColumnFieldFilter filter = null;

		if (bean instanceof UpdateSetColumnFieldFilter) {
			filter = (UpdateSetColumnFieldFilter) bean;
		}

		return updateColumnsSpecified(filter, bean);
	}

	public int updateColumnsSpecified(UpdateSetColumnFieldFilter filter,
			Object bean) {

		this.mediumSessionMapperInterceptor.before("update", bean);

		if (bean instanceof MediumModelInterceptor) {
			((MediumModelInterceptor) bean).before("update");
		}

		PersistentBeanTableDefinitionRegistry.getInstance()
				.getPersistentBeanTableDefinition(bean.getClass())
				.invokeBeforeUpdate(bean);

		int result = updateExecute(bean, MediumSessionOperations.UPDATE, filter);

		if (bean instanceof MediumModelInterceptor) {
			((MediumModelInterceptor) bean).after("update", result);
		}
		return result;
	}

	public int copy(Object bean) {

		this.mediumSessionMapperInterceptor.before("copy", bean);

		if (bean instanceof MediumModelInterceptor) {
			((MediumModelInterceptor) bean).before("copy");
		}

		int result = updateExecute(bean, MediumSessionOperations.COPY);

		if (bean instanceof MediumModelInterceptor) {
			((MediumModelInterceptor) bean).after("copy", result);
		}

		return result;
	}

	public int copyWithDelete(Object bean) {

		copy(bean);

		return this.delete(bean);
	}

	public Object find(Object bean) {

		Assert.notNull(bean, "Must provide persistent bean!");

		MediumSessionPreparedStatementSetter callback = new MediumSessionPreparedStatementSetterImpl(
				bean, MediumSessionOperations.SEARTH_BY_PK);

		MediumSessionResultSetExtractor extractor = new MediumSessionResultSetExtractor(
				bean.getClass());

		LOGGER.info("Exists SQL:" + callback.getExecutedSQL());

		return super.query(callback.getExecutedSQL(), callback, extractor);
	}

	public List findList(Object bean) {

		Assert.notNull(bean, "Must provide persistent bean!");

		MediumSessionPreparedStatementSetter callback = new MediumSessionPreparedStatementSetterImpl(
				bean, MediumSessionOperations.SEARTH_BY_PK);

		LOGGER.info("Exists SQL:" + callback.getExecutedSQL());

		MediumSessionResultSetsExtractor extractor = new MediumSessionResultSetsExtractor(
				bean.getClass());

		return (List) super.query(callback.getExecutedSQL(), callback,
				extractor);

	}

	public <T> List<T> findAll(Class<T> clz) {

		MediumSessionPreparedStatementSetter callback = new MediumSessionPreparedStatementSetterImpl(
				clz, MediumSessionOperations.QUERY_LIST_FOR_ALL);

		MediumSessionResultSetsExtractor extractor = new MediumSessionResultSetsExtractor(
				clz);

		LOGGER.info("Exists SQL:" + callback.getExecutedSQL());

		return (List<T>) super.query(callback.getExecutedSQL(), callback,
				extractor);

	}

	public <T> T find(Class<T> clz, final String primaryKey) {

		MediumSessionPreparedStatementSetter callback = new MediumSessionPreparedStatementPrimaryKeySetter(
				MediumSessionOperations.SEARTH_BY_PK, clz, primaryKey);

		LOGGER.info("Exists SQL:" + callback.getExecutedSQL());

		MediumSessionResultSetExtractor extractor = new MediumSessionResultSetExtractor(
				clz);
		return (T) super.query(callback.getExecutedSQL(), callback, extractor);
	}

	public <T> T find(Class<T> clz, final long primaryKey) {

		MediumSessionPreparedStatementSetter callback = new MediumSessionPreparedStatementPrimaryKeySetter(
				MediumSessionOperations.SEARTH_BY_PK, clz, primaryKey);

		LOGGER.info("Exists SQL:" + callback.getExecutedSQL());

		MediumSessionResultSetExtractor extractor = new MediumSessionResultSetExtractor(
				clz);
		return (T) super.query(callback.getExecutedSQL(), callback, extractor);
	}

	public <T> T find(Class<T> clz, final int primaryKey) {

		MediumSessionPreparedStatementSetter callback = new MediumSessionPreparedStatementPrimaryKeySetter(
				MediumSessionOperations.SEARTH_BY_PK, clz, primaryKey);

		LOGGER.info("Exists SQL:" + callback.getExecutedSQL());

		MediumSessionResultSetExtractor extractor = new MediumSessionResultSetExtractor(
				clz);
		return (T) super.query(callback.getExecutedSQL(), callback, extractor);
	}

	public List queryList(Object bean) {

		return queryList(bean, MediumMapperSqlInterceptor.INTERCEPTOR);
	}

	public int deleteWithQuery(Object bean) {

		LOGGER
				.info("int deleteWithQuery(T bean, MeduimMapperSQLInterceptor sqlInterceptor) called");

		Assert.notNull(bean, "Must provide persistent bean!");

		MediumSessionPreparedStatementSetter callback = new MediumSessionPreparedStatementSetterImpl(
				bean, MediumSessionOperations.DELETE_BY_QUERY);

		LOGGER.info("Exists SQL:" + callback.getExecutedSQL());

		return super.update(callback.getExecutedSQL(), callback);
	}

	public List queryList(Object bean, MediumMapperSqlInterceptor sqlInterceptor) {

		LOGGER
				.info("List<T> queryList(T bean, MeduimMapperSQLInterceptor sqlInterceptor) called");

		Assert.notNull(bean, "Must provide persistent bean!");

		MediumSessionPreparedStatementSetter callback = new MediumSessionPreparedStatementSetterImpl(
				bean, MediumSessionOperations.QUERY_LIST_BY_PK);

		LOGGER.info("Exists SQL:" + callback.getExecutedSQL());

		callback.addMeduimMapperSQLInterceptor(sqlInterceptor);

		ResultSetExtractor extractor = new MediumSessionResultSetsExtractor(
				bean.getClass());

		if (sqlInterceptor instanceof MeduimMapperPagerollSQLInterceptor) {

			sqlInterceptor.setTotalCount(queryListCount(bean));
		}

		return (List) super.query(callback.getExecutedSQL(), callback,
				extractor);
	}

	public int queryListCount(Object bean) {

		MediumSessionPreparedStatementSetter callback = new MediumSessionPreparedStatementSetterImpl(
				bean, MediumSessionOperations.QUERY_LIST_COUNT_BY_PK);

		LOGGER.info("Exists SQL:" + callback.getExecutedSQL());

		return super.query(callback.getExecutedSQL(), callback,
				new ResultSetExtractor<Integer>() {

					public Integer extractData(ResultSet rs)
							throws SQLException, DataAccessException {

						rs.next();

						return rs.getInt(1);
					}
				});

	}

	public Object queryOne(Object bean) {

		List rs = queryList(bean);

		return TypeChecker.isEmpty(rs) ? ConstructorUtils.newInstance(bean
				.getClass()) : rs.get(0);
	}

	public Object queryOneWithNull(Object bean) {

		List rs = queryList(bean);

		return TypeChecker.isEmpty(rs) ? null : rs.get(0);
	}

	public boolean existsForQuery(Object bean) {

		List rs = queryList(bean);

		return !TypeChecker.isEmpty(rs);
	}

	public int delete(Object bean) {
		return updateExecute(bean, MediumSessionOperations.DELETE);
	}

	public int delete(Class clz, final String primaryKey) {

		MediumSessionPreparedStatementSetter callback = new MediumSessionPreparedStatementPrimaryKeySetter(
				MediumSessionOperations.DELETE, clz, primaryKey);

		LOGGER.info("Exists SQL:" + callback.getExecutedSQL());

		return super.update(callback.getExecutedSQL(), callback);

	}

	public int delete(Class clz, final long primaryKey) {

		MediumSessionPreparedStatementSetter callback = new MediumSessionPreparedStatementPrimaryKeySetter(
				MediumSessionOperations.DELETE, clz, primaryKey);

		LOGGER.info("Exists SQL:" + callback.getExecutedSQL());

		return super.update(callback.getExecutedSQL(), callback);
	}

	public int delete(Class clz, final int primaryKey) {

		MediumSessionPreparedStatementSetter callback = new MediumSessionPreparedStatementPrimaryKeySetter(
				MediumSessionOperations.DELETE, clz, primaryKey);

		LOGGER.info("Exists SQL:" + callback.getExecutedSQL());

		return super.update(callback.getExecutedSQL(), callback);
	}

	private int updateExecute(final Object bean, int operationType) {
		return this.updateExecute(bean, operationType, null);
	}

	private int updateExecute(final Object bean, int operationType,
			UpdateSetColumnFieldFilter columnFieldFilter) {

		Assert.notNull(bean, "Must provide persistent bean!");

		MediumSessionPreparedStatementSetter callback = new MediumSessionPreparedStatementSetterImpl(
				bean, operationType);
		callback.setColumnFieldFilter(columnFieldFilter);

		LOGGER.info("UpdateExecute SQL:" + callback.getExecutedSQL());

		return super.update(callback.getExecutedSQL(), callback);
	}

	public void queryWithRowCallback(Class beanClass, String whereSql,
			MediumSessionRowRelatiedObjectMapperCallback callback,
			Object... args) {

		LOGGER
				.info("void queryWithRowCallback(Class beanClass, String whereSql,MediumSessionRowRelatiedObjectMapperCallback callback,Object... args) called");

		Assert.notNull(beanClass, "Must provide persistent bean!");

		MediumSessionResultSetRowCallbackHandler handler = new MediumSessionResultSetRowCallbackHandler(
				beanClass, callback);

		LOGGER.info("Exists SQL:"
				+ handler.getPersistentBeanTableDefinition().getSpecifiedSQL(
						whereSql));

		super.query(handler.getPersistentBeanTableDefinition().getSpecifiedSQL(
				whereSql), args, (RowCallbackHandler) handler);

		handler.afterProcess();

	}

	public <T> List<T> query(Class<T> beanClass, String whereSql,
			Object... args) {

		LOGGER
				.info("List<T> query(Class beanClass, String whereSql, Object... args) called");

		Assert.notNull(beanClass, "Must provide persistent bean!");

		MediumSessionObjectListByRowCallbackHandler callback = new MediumSessionObjectListByRowCallbackHandler(
				beanClass);

		LOGGER.info("Exists SQL:"
				+ callback.getPersistentBeanTableDefinition().getSpecifiedSQL(
						whereSql));

		super
				.query(callback.getPersistentBeanTableDefinition()
						.getSpecifiedSQL(whereSql), args,
						(RowCallbackHandler) callback);

		return callback.getResults();
	}

	public void setMediumSessionMapperInterceptor(
			MediumSessionMapperOperationInterceptor mediumSessionMapperInterceptor) {
		this.mediumSessionMapperInterceptor = mediumSessionMapperInterceptor;
	}

	public int getAutoIncreaseNumberAfterInsert() {

		String autoIncreaseIdSql = PersistentBeanTableDefinitionRegistry
				.getInstance().getMeduimMapperConfigurer()
				.getAutoIncreaseIdSql();

		return super.queryForInt(autoIncreaseIdSql);
	}

}
