package com.rapid.j2ee.framework.orm.medium;

import java.util.List;

import com.rapid.j2ee.framework.core.reflect.BeanMergePropertyAcceptor;
import com.rapid.j2ee.framework.orm.medium.filter.UpdateSetColumnFieldFilter;
import com.rapid.j2ee.framework.orm.medium.interceptor.MediumMapperSqlInterceptor;

public interface MediumSessionMapperOperations {

	void queryWithRowCallback(Class beanClass, String whereSql,
			MediumSessionRowRelatiedObjectMapperCallback callback,
			Object... args);

	public <T> List<T> query(Class<T> beanClass, String whereSql,
			Object... args);

	public Object merge(Object bean);

	public List mergeList(List records);

	public List mergeList(List records, BeanMergePropertyAcceptor mergeAcceptor);

	public Object merge(Object bean, BeanMergePropertyAcceptor mergeAcceptor);

	public Object mergeNotUpdate(Object bean);

	public Object mergeNotUpdate(Object bean,
			BeanMergePropertyAcceptor mergeAcceptor);

	public Object saveOrUpdate(Object bean);

	public boolean setObjectPrimaryKeyValues(Object bean);

	public <T> List<T> insertList(List<T> records);

	public boolean exists(Object bean);

	public boolean exists(Class clz, final String primaryKey);

	public boolean exists(Class clz, final int primaryKey);

	public boolean exists(Class clz, final long primaryKey);

	public int insert(Object bean);

	public int update(Object bean);

	public int[] updateList(List beans);

	public int updateColumnsSpecified(UpdateSetColumnFieldFilter filter,
			Object bean);

	public int copy(Object bean);

	public int copyWithDelete(Object bean);

	public Object find(Object bean);

	public List findList(Object bean);

	public <T> T find(Class<T> clz, final String primaryKey);

	public <T> T find(Class<T> clz, final long primaryKey);

	public <T> T find(Class<T> clz, final int primaryKey);

	public List queryList(Object bean);

	public boolean existsForQuery(Object bean);

	public Object queryOne(Object bean);

	public Object queryOneWithNull(Object bean);
	
	public int deleteWithQuery(Object bean);

	public int delete(Object bean);

	public int delete(Class clz, final String primaryKey);

	public int delete(Class clz, final long primaryKey);

	public int delete(Class clz, final int primaryKey);

	public <T> List<T> findAll(Class<T> clz);

	public <T> List<T> queryList(T bean,
			MediumMapperSqlInterceptor sqlInterceptor);

	public int getAutoIncreaseNumberAfterInsert();

	public static final String NULL_VALUE_IDENTITY = "{NULL}";

}
