package com.rapid.j2ee.framework.orm.medium.bean;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;

import org.apache.commons.lang.builder.ToStringBuilder;
import org.springframework.util.ReflectionUtils;

import com.rapid.j2ee.framework.core.reflect.BeanUtils;
import com.rapid.j2ee.framework.core.utils.ClassUtils;
import com.rapid.j2ee.framework.core.utils.StringUtils;
import com.rapid.j2ee.framework.core.utils.TypeChecker;
import com.rapid.j2ee.framework.orm.medium.MediumSessionOperations;
import com.rapid.j2ee.framework.orm.medium.annotation.ID;
import com.rapid.j2ee.framework.orm.medium.field.FieldColumn;
import com.rapid.j2ee.framework.orm.medium.field.PersistentBeanTableDefinition;
import com.rapid.j2ee.framework.orm.medium.mapper.PersistentBeanTableDefinitionRegistry;

public abstract class BaseMediumBean implements java.io.Serializable {

	private String operationType = "UNKNOWN";

	private static final long serialVersionUID = -1344663819575098305L;

	public boolean isNew() {
		return isPrimaryKeyEmpty();
	}

	public boolean isPrimaryKeyEmpty() {

		PersistentBeanTableDefinition def = PersistentBeanTableDefinitionRegistry

		.getInstance().getPersistentBeanTableDefinition(getClass());

		List<FieldColumn> columns = def.getFieldColumns();

		for (FieldColumn f : columns) {

			if (!f.isPrimaryKey(MediumSessionOperations.SEARTH_BY_PK)) {
				continue;
			}

			if (TypeChecker.isEmpty(BeanUtils.getProperty(this, f.getField()
					.getName()))) {
				return true;
			}
		}

		return false;
	}

	@Override
	public int hashCode() {

		if (!PersistentBeanTableDefinitionRegistry.getInstance().exits(
				this.getClass())) {
			return super.hashCode();
		}

		int hashCode = 0;

		PersistentBeanTableDefinition def = PersistentBeanTableDefinitionRegistry

		.getInstance().getPersistentBeanTableDefinition(getClass());

		List<FieldColumn> columns = def.getFieldColumns();

		for (FieldColumn f : columns) {

			if (!f.isPrimaryKey(MediumSessionOperations.SEARTH_BY_PK)) {
				continue;
			}

			Object value = BeanUtils.getProperty(this, f.getField().getName());

			if (!TypeChecker.isNull(value)) {
				hashCode += value.hashCode() * 17;
			}
		}

		return hashCode == 0 ? super.hashCode() : hashCode;
	}

	@Override
	public boolean equals(Object obj) {

		if (this == obj) {
			return true;
		}

		if (!PersistentBeanTableDefinitionRegistry.getInstance().exits(
				this.getClass())) {
			return super.equals(obj);
		}

		PersistentBeanTableDefinition def = PersistentBeanTableDefinitionRegistry

		.getInstance().getPersistentBeanTableDefinition(getClass());

		List<FieldColumn> columns = def.getFieldColumns();

		List<String> pkFieldNames = new ArrayList<String>();

		for (FieldColumn f : columns) {

			if (!f.isPrimaryKey(MediumSessionOperations.SEARTH_BY_PK)) {
				continue;
			}

			pkFieldNames.add(f.getField().getName());
		}

		String value = StringUtils.getStringBunchByObjectFieldNames(this, "_",
				pkFieldNames.toArray(new String[pkFieldNames.size()]));

		return value.equalsIgnoreCase(StringUtils
				.getStringBunchByObjectFieldNames(obj, "_", pkFieldNames
						.toArray(new String[pkFieldNames.size()])));
	}

	public String toString() {
		return ToStringBuilder.reflectionToString(this);
	}

	public String getOperationType() {
		return operationType;
	}

	public boolean isInsertOperation() {
		return "INSERT".equalsIgnoreCase(this.operationType);
	}

	public void setInsertOperation() {
		this.operationType = "INSERT";
	}

	public void setUpdateOperation() {
		this.operationType = "UPDATE";
	}

	public void setDeleteOperation() {
		this.operationType = "DELETE";
	}

	public void setSearchOperation() {
		this.operationType = "SEARCH";
	}

	public void setCopyOperation() {
		this.operationType = "COPY";
	}

	public void clearQueryValues() {

		Field[] fs = ClassUtils.getAllFieldsAsClassByAnnotation(
				this.getClass(), ID.class);

		for (Field f : fs) {
			try {
				ReflectionUtils.makeAccessible(f);
				ReflectionUtils.setField(f, this, null);

			} catch (Exception e) {

			}

		}
	}

}
