package com.rapid.j2ee.framework.orm.medium.field;

import java.io.Serializable;
import java.lang.reflect.Field;

import com.rapid.j2ee.framework.core.annoconverter.converter.SqlLikeType;
import com.rapid.j2ee.framework.core.utils.StringUtils;
import com.rapid.j2ee.framework.core.utils.TypeChecker;
import com.rapid.j2ee.framework.orm.medium.MediumSessionOperations;
import com.rapid.j2ee.framework.orm.medium.annotation.Column;
import com.rapid.j2ee.framework.orm.medium.annotation.ID;
import com.rapid.j2ee.framework.orm.medium.annotation.Order;
import com.rapid.j2ee.framework.orm.medium.annotation.SysDate;
import com.rapid.j2ee.framework.orm.medium.annotation.ID.IDMode;
import com.rapid.j2ee.framework.orm.medium.configurer.MeduimMapperConfigurer;
import com.rapid.j2ee.framework.orm.medium.table.TableColumn;

public class FieldColumn implements Serializable, Comparable<FieldColumn> {

	private Field field;

	private boolean primaryKey;

	private TableColumn column;

	private Column columnAnnoation;

	private SysDate sysDate;

	private MeduimMapperConfigurer mapperConfigurer;

	private ID idAnnotation;

	private Order orderAnnotation;

	private IDMode idMode = IDMode.UNKNOWN;

	private SqlLikeType sqlLikeType;

	public boolean isPrimaryKey(int operation) {

		if (primaryKey == false) {
			return false;
		}

		return ((MediumSessionOperations.QUERY_LIST_BY_PK == operation)
				|| (MediumSessionOperations.DELETE_BY_QUERY == operation) || (MediumSessionOperations.QUERY_LIST_COUNT_BY_PK == operation)) ? isPrimaryKeyByMode(IDMode.QUERY)
				|| isPrimaryKeyByMode(IDMode.IDQUERY)
				|| isPrimaryKeyByMode(IDMode.QUERYNULL)
				: isPrimaryKeyByMode(IDMode.ID)
						|| isPrimaryKeyByMode(IDMode.IDQUERY);
	}

	public boolean isNullQuery() {
		return idMode == IDMode.QUERYNULL;
	}

	private boolean isPrimaryKeyByMode(IDMode mode) {

		if (TypeChecker.isNull(idAnnotation)) {
			return false;
		}

		return idAnnotation.value() == mode;

	}

	public ID getIdAnnotation() {
		return idAnnotation;
	}

	public boolean isAutoIncreaseId() {
		if (TypeChecker.isNull(idAnnotation)) {
			return false;
		}

		return idAnnotation.autoIncrease();
	}

	public FieldColumn(MeduimMapperConfigurer mapperConfigurer, Field field,
			TableColumn column) {

		this.mapperConfigurer = mapperConfigurer;

		this.field = field;
		this.column = column;
		this.columnAnnoation = field.getAnnotation(Column.class);

		sysDate = field.getAnnotation(SysDate.class);

		idAnnotation = field.getAnnotation(ID.class);

		primaryKey = column.isPrimaryKey();

		if (!TypeChecker.isNull(idAnnotation)) {
			primaryKey = true;
			idMode = idAnnotation.value();
		}

		orderAnnotation = field.getAnnotation(Order.class);

		this.sqlLikeType = field.getAnnotation(SqlLikeType.class);

	}

	public Object getValueBySqlLikeModePattern(int operationType, Object value) {

		if (operationType != MediumSessionOperations.QUERY_LIST_BY_PK
				&& operationType != MediumSessionOperations.QUERY_LIST_COUNT_BY_PK) {
			return value;
		}

		if (TypeChecker.isNull(this.sqlLikeType)) {
			return value;
		}

		if (value == null && this.sqlLikeType.supportsNull()) {
			return null;
		}

		String tempValue = "";

		if (value != null) {
			tempValue = StringUtils.trimToEmpty(value.toString());
		}

		if (this.sqlLikeType.value() == SqlLikeType.LikeType.Both) {
			tempValue = "%" + tempValue + "%";
		} else if (this.sqlLikeType.value() == SqlLikeType.LikeType.Left) {
			tempValue = tempValue + "%";
		} else if (this.sqlLikeType.value() == SqlLikeType.LikeType.Right) {
			tempValue = "%" + tempValue;
		}

		return tempValue;
	}

	public boolean isOrder() {
		return !TypeChecker.isNull(orderAnnotation);
	}

	public String getColumnDefaultValue() {

		if (!TypeChecker.isNull(sysDate)) {
			return sysDate.value();
		}

		String value = this.columnAnnoation.defaultValue();

		return "[NULL]".equals(value) ? null : value;
	}

	public String getDateFormat() {

		String value = this.columnAnnoation.dateFormat();

		return "[NULL]".equals(value) ? mapperConfigurer.getDateTimeFormat()
				: value;
	}

	public boolean isSysDate() {
		return !TypeChecker.isNull(this.sysDate);
	}

	public Column getColumnAnnoation() {
		return columnAnnoation;
	}

	public TableColumn getColumn() {
		return column;
	}

	public Field getField() {
		return field;
	}

	public String toString() {
		return "Field :" + field + " PrimaryKey :" + primaryKey + " Column:"
				+ this.column + " ID model:" + this.idMode;
	}

	public int getOrderSeqNo() {
		return orderAnnotation.value();
	}

	public int compareTo(FieldColumn o) {

		if (o == this) {
			return 0;
		}

		return this.getOrderSeqNo() - o.getOrderSeqNo();
	}

	public Order getOrder() {
		return orderAnnotation;
	}

	public boolean supportsLike() {
		return this.column.supportsLike();
	}

}
