package com.rapid.j2ee.framework.orm.medium.field;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import org.apache.commons.lang.builder.ToStringBuilder;

import com.rapid.j2ee.framework.core.exception.ExceptionUtils;
import com.rapid.j2ee.framework.core.reflect.BeanUtils;
import com.rapid.j2ee.framework.core.utils.ClassUtils;
import com.rapid.j2ee.framework.core.utils.ObjectUtils;
import com.rapid.j2ee.framework.core.utils.StringUtils;
import com.rapid.j2ee.framework.core.utils.TypeChecker;
import com.rapid.j2ee.framework.orm.formatter.annotation.FormatterAdditionalColumn;
import com.rapid.j2ee.framework.orm.medium.MediumQueryAnnotationAcceptor;
import com.rapid.j2ee.framework.orm.medium.MediumSessionMapperOperations;
import com.rapid.j2ee.framework.orm.medium.MediumSessionOperations;
import com.rapid.j2ee.framework.orm.medium.annotation.BeforeInsert;
import com.rapid.j2ee.framework.orm.medium.annotation.BeforeUpdate;
import com.rapid.j2ee.framework.orm.medium.annotation.Table;
import com.rapid.j2ee.framework.orm.medium.annotation.TableCopy;
import com.rapid.j2ee.framework.orm.medium.configurer.MeduimMapperConfigurer;
import com.rapid.j2ee.framework.orm.medium.filter.ColumnFieldFilter;
import com.rapid.j2ee.framework.orm.medium.filter.UpdateSetColumnFieldFilter;
import com.rapid.j2ee.framework.orm.medium.mapper.MediumPersistentBeanParser;
import com.rapid.j2ee.framework.orm.medium.table.TableColumn;

public class PersistentBeanTableDefinition {

	private String tableName;

	private String schema;

	private List<FieldColumn> fieldColumns;

	private MeduimMapperConfigurer mapperConfigurer;

	private List<FieldColumn> fieldOrderColumns;

	private TableCopy tableCopyAnnotation;

	private Table tableAnnotation;

	private Class tableClass;

	private List<FieldColumn> formattedFieldColumns;

	private Method beforeInsertMethod;

	private Method beforeUpdateMethod;

	public PersistentBeanTableDefinition setMeduimMapperConfigurer(
			MeduimMapperConfigurer mapperConfigurer) {
		this.mapperConfigurer = mapperConfigurer;
		return this;
	}

	public MeduimMapperConfigurer getMapperConfigurer() {
		return mapperConfigurer;
	}

	public List<FieldColumn> getFieldColumns() {
		return fieldColumns;
	}

	public List<FieldColumn> getFormattedFieldColumns() {
		return formattedFieldColumns;
	}

	public PersistentBeanTableDefinition(Class tableClass, String schema,
			Table tableAnnotation, TableCopy tableCopyAnnotation, int fieldSize) {
		this.tableClass = tableClass;
		this.tableAnnotation = tableAnnotation;
		this.tableName = MediumPersistentBeanParser
				.getRealTableName(tableAnnotation);
		this.schema = schema;
		fieldColumns = new ArrayList<FieldColumn>(fieldSize);
		fieldOrderColumns = ObjectUtils.EMPTY_LIST;
		this.tableCopyAnnotation = tableCopyAnnotation;

		beforeInsertMethod = ClassUtils.getMethodAsClassByAnnotation(
				tableClass, BeforeInsert.class);

		beforeUpdateMethod = ClassUtils.getMethodAsClassByAnnotation(
				tableClass, BeforeUpdate.class);
	}

	public void invokeBeforeInsert(Object bean) {
		if (TypeChecker.isNull(beforeInsertMethod)) {
			return;
		}

		try {
			beforeInsertMethod.invoke(bean, null);
		} catch (Exception e) {
			throw ExceptionUtils.convertThrowableToBaseException(e);
		}
	}

	public void invokeBeforeUpdate(Object bean) {
		if (TypeChecker.isNull(this.beforeUpdateMethod)) {
			return;
		}

		try {
			beforeUpdateMethod.invoke(bean, null);
		} catch (Exception e) {
			throw ExceptionUtils.convertThrowableToBaseException(e);
		}
	}

	public synchronized void initializeBean() {
		this.initializeFormattedAdditionalColumns();
	}

	private void initializeFormattedAdditionalColumns() {

		formattedFieldColumns = new ArrayList<FieldColumn>(
				fieldColumns.size() + 5);

		formattedFieldColumns.addAll(this.fieldColumns);

		Field[] fields = ClassUtils.getAllFieldsAsClassByAnnotation(tableClass,
				FormatterAdditionalColumn.class);

		for (Field f : fields) {

			FieldColumn fc = new FieldColumn(mapperConfigurer, f,
					new TableColumn(StringUtils.trimToEmpty(f.getAnnotation(
							FormatterAdditionalColumn.class).value(), f
							.getName().toUpperCase())));
			formattedFieldColumns.add(fc);
		}
	}

	public void addFieldColumn(FieldColumn column) {
		fieldColumns.add(column);
	}

	public String getSchemaTable() {
		return TypeChecker.isEmpty(this.schema) ? this.tableName : this.schema
				+ "." + this.tableName;
	}

	public String getSchemaTableCopy() {
		return TypeChecker.isEmpty(this.schema) ? this.tableCopyAnnotation
				.value() : this.schema + "." + this.tableCopyAnnotation.value();
	}

	public String getTableColumnRevised(int operationType, String column) {
		return mapperConfigurer.getColumnNamingResovler().resolve(
				operationType, column);
	}

	public String getInsertSQL() {

		StringBuffer sqls = new StringBuffer(this.getSchemaTable().length()
				+ fieldColumns.size() * 25);
		sqls.append("INSERT INTO " + this.getSchemaTable() + " ( ");

		StringBuffer sqlValues = new StringBuffer(fieldColumns.size() * 5);

		for (FieldColumn column : fieldColumns) {

			if (column.isAutoIncreaseId()) {
				continue;
			}

			sqls.append(getTableColumnRevised(MediumSessionOperations.INSERT,
					column.getColumn().getColumnName()));
			sqls.append(",");
			sqlValues.append("?");
			sqlValues.append(",");
		}

		return sqls.substring(0, sqls.length() - 1) + ") VALUES ("
				+ sqlValues.substring(0, sqlValues.length() - 1) + ")";

	}

	public String getSpecifiedSQL(String whereSql) {

		whereSql = StringUtils.trimToEmpty(whereSql, "1=1");

		StringBuffer searchSql = new StringBuffer(this.getSchemaTable()
				.length()
				+ fieldColumns.size() * 25 + whereSql.length());

		searchSql.append("SELECT ");

		for (FieldColumn column : fieldColumns) {
			searchSql.append(getTableColumnRevised(
					MediumSessionOperations.QUERY_BY_SPECIFICATION, column
							.getColumn().getColumnName()));

			searchSql.append(",");

		}

		return searchSql.substring(0, searchSql.length() - 1) + " FROM "
				+ this.getSchemaTable() + " WHERE " + whereSql;

	}

	public String getUpdateSQL(ColumnFieldFilter columnFieldFilter) {

		StringBuffer updateHeaderSql = new StringBuffer(this.getSchemaTable()
				.length()
				+ fieldColumns.size() * 25);

		updateHeaderSql.append("UPDATE " + this.getSchemaTable() + " SET ");

		for (FieldColumn column : fieldColumns) {

			if (!isPrimaryKeyUpdated()
					&& column.isPrimaryKey(MediumSessionOperations.UPDATE)) {
				continue;
			}

			if (columnFieldFilter instanceof UpdateSetColumnFieldFilter) {

				if (!((UpdateSetColumnFieldFilter) columnFieldFilter)
						.isSetColumnAvailable(column)) {
					continue;
				}
			}

			updateHeaderSql.append(getTableColumnRevised(
					MediumSessionOperations.UPDATE, column.getColumn()
							.getColumnName())
					+ "=?,");

		}

		StringBuffer updateWhereSql = new StringBuffer(50);

		updateWhereSql.append(" WHERE ");

		for (FieldColumn column : fieldColumns) {

			if (!column.isPrimaryKey(MediumSessionOperations.UPDATE)) {
				continue;
			}

			updateWhereSql.append(getTableColumnRevised(
					MediumSessionOperations.SEARTHWHERE_BY_PK, column
							.getColumn().getColumnName())
					+ "=? AND");

		}

		updateWhereSql.append(" 1=1");

		return updateHeaderSql.substring(0, updateHeaderSql.length() - 1)
				+ updateWhereSql;

	}

	public String getDeleteSQL() {
		return this.getDeleteSQL(null);
	}

	public String getDeleteSQL(Object bean) {

		StringBuffer deleteSql = new StringBuffer(this.getSchemaTable()
				.length() + 25);

		deleteSql.append("DELETE FROM " + this.getSchemaTable() + " WHERE ");

		for (FieldColumn column : fieldColumns) {

			if (!column.isPrimaryKey(MediumSessionOperations.DELETE)) {
				continue;
			}

			if (isNullForDelete(bean, column)) {
				continue;
			}

			deleteSql.append(getTableColumnRevised(
					MediumSessionOperations.DELETE, column.getColumn()
							.getColumnName())
					+ "=? AND ");

		}

		return deleteSql.substring(0, deleteSql.length() - 4);

	}

	public String getCopySQL() {

		StringBuffer copySql = new StringBuffer(this.getSchemaTable().length()
				+ fieldColumns.size() * 10);

		copySql.append("INSERT INTO " + this.getSchemaTableCopy() + " ");

		copySql.append("SELECT * FROM " + this.getSchemaTable() + " WHERE ");

		for (FieldColumn column : fieldColumns) {

			if (!column.isPrimaryKey(MediumSessionOperations.DELETE)) {
				continue;
			}

			copySql.append(getTableColumnRevised(
					MediumSessionOperations.DELETE, column.getColumn()
							.getColumnName())
					+ "=? AND ");

		}

		return copySql.substring(0, copySql.length() - 4);

	}

	public String getFindCountsSQL() {

		StringBuffer findWhereSql = new StringBuffer(50);

		findWhereSql.append(" FROM " + this.getSchemaTable() + " WHERE ");

		for (FieldColumn column : fieldColumns) {

			if (!column
					.isPrimaryKey(MediumSessionOperations.SEARTH_COUNTS_BY_PK)) {
				continue;
			}

			findWhereSql.append(getTableColumnRevised(
					MediumSessionOperations.SEARTHWHERE_BY_PK, column
							.getColumn().getColumnName())
					+ "=? AND ");

		}

		return "SELECT COUNT(1) "
				+ findWhereSql.substring(0, findWhereSql.length() - 4);
	}

	public String getFindOrQuerySQL(int type) {
		return getFindOrQuerySQL(type, null);
	}

	public String getDeleteQuerySQL(int type, Object bean) {
		return "DELETE FROM "
				+ StringUtils
						.substringAfter(
								getFindOrQuerySQL(MediumSessionOperations.QUERY_LIST_BY_PK),
								" FROM ");
	}

	public String getFindOrQuerySQL(int type, Object bean) {

		StringBuffer findHeaderSql = new StringBuffer(this.getSchemaTable()
				.length()
				+ fieldColumns.size() * 25);

		findHeaderSql.append("SELECT ");

		for (FieldColumn column : fieldColumns) {

			findHeaderSql.append(getTableColumnRevised(type, column.getColumn()
					.getColumnName())
					+ ",");

		}

		StringBuffer findWhereSql = new StringBuffer(50);

		if (type == MediumSessionOperations.QUERY_LIST_FOR_ALL) {

			findWhereSql.append(" FROM " + this.getSchemaTable());

			return findHeaderSql.substring(0, findHeaderSql.length() - 1)
					+ findWhereSql.toString();
		}

		findWhereSql.append(" FROM " + this.getSchemaTable() + " WHERE ");

		boolean queryWhereSql = (MediumSessionOperations.QUERY_LIST_BY_PK == type);

		for (FieldColumn column : fieldColumns) {

			if (!column.isPrimaryKey(type)) {
				continue;
			}

			if (queryWhereSql && bean instanceof MediumQueryAnnotationAcceptor) {
				if (!((MediumQueryAnnotationAcceptor) bean).accept(column
						.getField())) {
					continue;
				}
			}

			if (queryWhereSql && isNULL(bean, column)) {

				if (column.isNullQuery()) {

					findWhereSql.append(getTableColumnRevised(type, column
							.getColumn().getColumnName())
							+ " IS NULL AND ");
				}

				continue;
			}

			if (queryWhereSql) {

				if (column.supportsLike()) {
					findWhereSql.append(getTableColumnRevised(type, column
							.getColumn().getColumnName())
							+ " LIKE ? AND ");
				} else {
					findWhereSql.append(getTableColumnRevised(type, column
							.getColumn().getColumnName())
							+ " = ? AND ");
				}

				continue;
			}

			findWhereSql.append(getTableColumnRevised(type, column.getColumn()
					.getColumnName())
					+ " = ? AND ");

		}

		return findHeaderSql.substring(0, findHeaderSql.length() - 1)
				+ findWhereSql.substring(0, findWhereSql.length() - 4);
	}

	public static boolean isNullForDelete(Object bean, FieldColumn column) {

		if (TypeChecker.isNull(bean) || column.getIdAnnotation() == null) {
			return false;
		}

		Object objValue = BeanUtils.getPropertyObject(bean, column.getField()
				.getName());

		if (column.getIdAnnotation().nullNotSql()) {
			return TypeChecker.isNull(objValue)
					|| TypeChecker.isEmpty(String.valueOf(objValue))
					|| MediumSessionMapperOperations.NULL_VALUE_IDENTITY
							.equalsIgnoreCase(String.valueOf(objValue));
		}

		return false;

	}

	public static boolean isNULL(Object bean, FieldColumn column) {

		if (TypeChecker.isNull(bean)) {
			return false;
		}
		Object objValue = BeanUtils.getPropertyObject(bean, column.getField()
				.getName());

		return TypeChecker.isNull(objValue)
				|| TypeChecker.isEmpty(String.valueOf(objValue))
				|| MediumSessionMapperOperations.NULL_VALUE_IDENTITY
						.equalsIgnoreCase(String.valueOf(objValue));

	}

	private synchronized void prepareOrders() {

		if (fieldOrderColumns != ObjectUtils.EMPTY_LIST) {
			return;
		}

		fieldOrderColumns = new ArrayList<FieldColumn>(3);

		for (FieldColumn column : fieldColumns) {

			if (!column.isOrder()) {
				continue;
			}

			fieldOrderColumns.add(column);
		}

		Collections.sort((List) fieldOrderColumns);

	}

	public String getOrderSql(int type) {

		prepareOrders();

		StringBuffer orderSql = new StringBuffer(80);

		for (FieldColumn column : fieldOrderColumns) {

			orderSql.append(this.mapperConfigurer.getColumnOrderResovler()
					.order(
							getTableColumnRevised(type, column.getColumn()
									.getColumnName()), column.getOrder())
					+ " ,");

		}

		if (TypeChecker.isEmpty(orderSql)) {
			return "";
		}

		return " ORDER BY "
				+ orderSql.substring(0, orderSql.length() - 1).toUpperCase();
	}

	public boolean isPrimaryKeyUpdated() {
		return this.tableAnnotation.updatePrimaryKey();
	}

	public String toString() {
		return ToStringBuilder.reflectionToString(this);
	}

	public TableCopy getTableCopyAnnotation() {
		return tableCopyAnnotation;
	}

	public Field getFieldByAnnotation(
			Class<? extends Annotation> annotationClass) {

		for (FieldColumn fieldColumn : this.fieldColumns) {
			if (fieldColumn.getField().isAnnotationPresent(annotationClass)) {
				return fieldColumn.getField();
			}
		}

		return null;
	}

	public List<Field> getFieldByAnnotations(
			Class<? extends Annotation> annotationClass) {

		List<Field> fields = new ArrayList<Field>(5);
		for (FieldColumn fieldColumn : this.fieldColumns) {
			if (fieldColumn.getField().isAnnotationPresent(annotationClass)) {
				fields.add(fieldColumn.getField());
			}
		}

		return fields;
	}
}
