package com.rapid.j2ee.framework.orm.medium.getter;

import java.lang.reflect.Field;
import java.sql.ResultSet;
import java.sql.SQLException;

import com.rapid.j2ee.framework.core.reflect.BeanUtils;
import com.rapid.j2ee.framework.core.utils.TypeChecker;
import com.rapid.j2ee.framework.orm.medium.field.FieldColumn;


public abstract class AbstractOutResultSetAcceptor implements
		OutResultSetAcceptor {

	public void setValueObject(Object bean, ResultSet rs, FieldColumn column)
			throws SQLException {

		Object value = getValueObject(rs, column, column.getColumn()
				.getColumnName(), column.getField(), column.getField()
				.getType());

		if (TypeChecker.isNull(value)) {
			value = getWasNullFilter(value);
		}

		BeanUtils.setProperty(bean, column.getField().getName(), value);
	}

	public abstract Object getValueObject(ResultSet rs, FieldColumn column,
			String tableColumn, Field field, Class type) throws SQLException;

	protected Object getWasNullFilter(Object value) {
		return value;
	}

}
