package com.rapid.j2ee.framework.orm.medium.getter;

import java.lang.reflect.Field;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;

import com.rapid.j2ee.framework.core.utils.ClassUtils;
import com.rapid.j2ee.framework.core.utils.DateTimeUtils;
import com.rapid.j2ee.framework.core.utils.TypeChecker;
import com.rapid.j2ee.framework.core.utils.support.DateTimeFormat;
import com.rapid.j2ee.framework.orm.medium.field.FieldColumn;

public class DateOutResultSetAcceptor extends AbstractOutResultSetAcceptor {

	@Override
	public Object getValueObject(ResultSet rs, FieldColumn column,
			String tableColumn, Field field, Class type) throws SQLException {

		Date date = rs.getDate(tableColumn);

		if (rs.wasNull() || TypeChecker.isNull(date)
				|| DateTimeUtils.getYear(date) <= 1900) {
			return null;
		}

		if (type == String.class) {

			try {
				return DateTimeFormat.getDateTimeFormat(column.getDateFormat())
						.getSimpleDateFormat().format(date);
			} catch (Exception e) {
				throw new SQLException("Convert Date Error! Date Value:" + date
						+ " Format:" + column.getDateFormat());
			}

		}

		if (date.getClass() == type) {
			return date;
		}

		if (type == Date.class) {

			return new java.util.Date(date.getTime());

		}

		if (type == java.sql.Date.class) {

			return new java.sql.Date(date.getTime());

		}

		if (type == java.sql.Timestamp.class) {

			return new java.sql.Timestamp(date.getTime());

		}

		return date;
	}

	protected Object getWasNullFilter(Object value) {
		return value;
	}

	public static void main(String[] args) {
		System.out.println(ClassUtils.isAssignable(java.sql.Timestamp.class,
				Date.class));
	}
}
