package com.rapid.j2ee.framework.orm.medium.getter;

import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;

import com.rapid.j2ee.framework.core.utils.TypeChecker;
import com.rapid.j2ee.framework.orm.medium.field.FieldColumn;

public class FloatOutResultSetAcceptor extends AbstractOutResultSetAcceptor {

	@Override
	public Object getValueObject(ResultSet rs, FieldColumn column,
			String tableColumn, Field field, Class type) throws SQLException {

		ResultSetWrapper wrapper = new ResultSetWrapper(rs);

		if (type == String.class) {
			return wrapper.getString(tableColumn);
		}

		Double d = wrapper.getDouble(tableColumn);

		if (TypeChecker.isNull(d)) {
			return d;
		}

		if (type == int.class || type == Integer.class) {

			return d.intValue();
		}

		if (type == double.class || type == Double.class) {
			return d;
		}

		if (type == long.class || type == Long.class) {
			return d.longValue();
		}

		if (type == float.class || type == Float.class) {
			return wrapper.getFloat(tableColumn);
		}

		if (type == BigDecimal.class || type == BigDecimal.class) {
			return BigDecimal.valueOf(d);
		}

		return wrapper.getFloat(tableColumn);

	}
}
