package com.rapid.j2ee.framework.orm.medium.getter;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

import org.springframework.dao.DataAccessException;

import com.rapid.j2ee.framework.core.utils.TypeChecker;
import com.rapid.j2ee.framework.mvc.exception.ManyTransactionsByPrimaryKeyApplicationException;
import com.rapid.j2ee.framework.mvc.exception.NoTransactionByPrimaryKeyApplicationException;
import com.rapid.j2ee.framework.orm.medium.MediumnSessionFetchResultsetEscapeException;

public class MediumSessionResultSetExtractor extends
		MediumSessionResultSetsExtractor {

	public MediumSessionResultSetExtractor(Class clz) {
		super(clz);

	}

	public Object extractData(ResultSet rs) throws SQLException,
			DataAccessException {

		List results = (List) super.extractData(rs);

		if (MediumnSessionFetchResultsetEscapeException.isExceptionEscaped()) {
			return TypeChecker.isEmpty(results) ? null : results.get(0);
		}

		if (TypeChecker.isEmpty(results)) {

			throw new NoTransactionByPrimaryKeyApplicationException();
		}

		if (results.size() > 1) {
			throw new ManyTransactionsByPrimaryKeyApplicationException();
		}

		return results.get(0);

	}

}
