package com.rapid.j2ee.framework.orm.medium.getter;

import java.sql.ResultSet;
import java.sql.SQLException;

import org.springframework.jdbc.core.RowCallbackHandler;

import com.rapid.j2ee.framework.orm.medium.MediumSessionRowRelatiedObjectMapperCallback;

public class MediumSessionResultSetRowCallbackHandler extends
		MediumSessionResultSetsExtractor implements RowCallbackHandler {

	private MediumSessionRowRelatiedObjectMapperCallback callback;

	private int recordCount = 0;

	public MediumSessionResultSetRowCallbackHandler(Class beanClass,
			MediumSessionRowRelatiedObjectMapperCallback callback) {
		super(beanClass);
		this.callback = callback;
	}

	public void processRow(ResultSet rs) throws SQLException {

		if (recordCount < 0) {
			return;
		}

		if (recordCount == 0 && !callback.before(definition, "ProcessRow")) {
			recordCount = -1;
			return;
		}

		recordCount++;

		callback.handle(definition, this.convertResultSetToBean(rs));

	}

	public void afterProcess() {
		callback.after(definition, "ProcessRow", recordCount);
	}

}
