package com.rapid.j2ee.framework.orm.medium.getter;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ResultSetExtractor;

import com.rapid.j2ee.framework.core.reflect.ConstructorUtils;
import com.rapid.j2ee.framework.orm.medium.configurer.MeduimMapperConfigurer;
import com.rapid.j2ee.framework.orm.medium.field.FieldColumn;
import com.rapid.j2ee.framework.orm.medium.field.PersistentBeanTableDefinition;
import com.rapid.j2ee.framework.orm.medium.mapper.PersistentBeanTableDefinitionRegistry;

public class MediumSessionResultSetsExtractor implements ResultSetExtractor {

	private Class beanClass;

	protected PersistentBeanTableDefinition definition;

	private MeduimMapperConfigurer configurer;

	public MediumSessionResultSetsExtractor(Class clz) {

		this.beanClass = clz;

		definition = PersistentBeanTableDefinitionRegistry.getInstance()
				.getPersistentBeanTableDefinition(beanClass);
		configurer = this.definition.getMapperConfigurer();

	}

	public PersistentBeanTableDefinition getPersistentBeanTableDefinition() {
		return this.definition;
	}

	public Object extractData(ResultSet rs) throws SQLException,
			DataAccessException {

		List results = new ArrayList(20);

		for (; rs.next();) {

			results.add(convertResultSetToBean(rs));
		}

		return results;

	}

	protected Object convertResultSetToBean(ResultSet rs) throws SQLException,
			DataAccessException {
		Object bean = ConstructorUtils.newInstance(beanClass);

		setBeanPropertyValues(rs, bean);

		return bean;
	}

	private void setBeanPropertyValues(ResultSet rs, Object bean)
			throws SQLException {

		List<FieldColumn> columns = definition.getFieldColumns();

		for (FieldColumn column : columns) {

			configurer.getOutResultSetAcceptor(column).setValueObject(bean, rs,
					column);
		}

	}

}
