package com.rapid.j2ee.framework.orm.medium.getter;

import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.Date;

import com.rapid.j2ee.framework.core.utils.ClassUtils;
import com.rapid.j2ee.framework.core.utils.StringUtils;
import com.rapid.j2ee.framework.core.utils.support.DateTimeFormat;
import com.rapid.j2ee.framework.orm.medium.field.FieldColumn;

public class NStringOutResultSetAcceptor extends AbstractOutResultSetAcceptor {

	@Override
	public Object getValueObject(ResultSet rs, FieldColumn column,
			String tableColumn, Field field, Class type) throws SQLException {

		String value = new ResultSetWrapper(rs).getNString(tableColumn);

		if (rs.wasNull()) {
			return null;
		}

		if (type == String.class) {

			return StringUtils.trimToEmpty(value);

		}

		if (ClassUtils.isAssignable(type, Date.class)) {

			try {
				return DateTimeFormat.getDateTimeFormat(column.getDateFormat())
						.getSimpleDateFormat().parse(value);
			} catch (ParseException e) {
				throw new SQLException("Convert Date Error! Date Value:"
						+ value + " Format:" + column.getDateFormat());
			}
		}

		if (type == int.class || type == Integer.class) {

			return Integer.valueOf(value);

		}

		if (type == long.class || type == Long.class) {

			return Long.valueOf(value);

		}

		if (type == float.class || type == Float.class) {

			return Float.valueOf(value);

		}

		if (type == double.class || type == Double.class) {

			return Double.valueOf(value);

		}

		if (type == BigDecimal.class || type == BigDecimal.class) {

			return new BigDecimal(value);

		}

		return value;
	}

	protected Object getWasNullFilter(Object value) {
		return value;
	}

	public static void main(String[] args) {
		System.out.println(ClassUtils.isAssignable(java.sql.Timestamp.class,
				Date.class));
	}
}
