package com.rapid.j2ee.framework.orm.medium.getter;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;

public class ResultSetWrapper {

	private ResultSet rs;

	private static boolean SUPPORT_NVARCHAR = true;

	public ResultSetWrapper(ResultSet rs) {
		this.rs = rs;
	}

	public String getNString(String tableColumn) throws SQLException {
		String value = getString(tableColumn);

		if (SUPPORT_NVARCHAR) {
			try {
				value = rs.getNString(tableColumn);
			} catch (Throwable e) {
				SUPPORT_NVARCHAR = false;
			}
		}

		return value;
	}

	public String getString(String tableColumn) throws SQLException {

		String value = rs.getString(tableColumn);

		if (rs.wasNull()) {
			return null;
		}

		return value;
	}

	public Integer getInteger(String tableColumn) throws SQLException {
		int i = rs.getInt(tableColumn);
		if (rs.wasNull()) {
			return null;
		}

		return Integer.valueOf(i);
	}

	public Long getLong(String tableColumn) throws SQLException {
		long l = rs.getLong(tableColumn);
		if (rs.wasNull()) {
			return null;
		}

		return Long.valueOf(l);
	}

	public Float getFloat(String tableColumn) throws SQLException {
		float f = rs.getFloat(tableColumn);
		if (rs.wasNull()) {
			return null;
		}

		return Float.valueOf(f);
	}

	public Double getDouble(String tableColumn) throws SQLException {
		double d = rs.getDouble(tableColumn);
		
		if (rs.wasNull()) {
			return null;
		}

		return Double.valueOf(d);
	}

	public BigDecimal getBigDecimal(String tableColumn) throws SQLException {
		BigDecimal dec = rs.getBigDecimal(tableColumn);
		if (rs.wasNull()) {
			return null;
		}

		return dec;
	}

}
