package com.rapid.j2ee.framework.orm.medium.getter;

import java.lang.reflect.Field;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;

import com.rapid.j2ee.framework.core.utils.ClassUtils;
import com.rapid.j2ee.framework.core.utils.support.DateTimeFormat;
import com.rapid.j2ee.framework.orm.medium.field.FieldColumn;

public class TimestampOutResultSetAcceptor extends AbstractOutResultSetAcceptor {

	@Override
	public Object getValueObject(ResultSet rs, FieldColumn column,
			String tableColumn, Field field, Class type) throws SQLException {

		Timestamp date = rs.getTimestamp(tableColumn);

		if (rs.wasNull()) {
			return null;
		}

		if (type == String.class) {

			try {
				return DateTimeFormat.getDateTimeFormat(column.getDateFormat())
						.getSimpleDateFormat().format(date);
			} catch (Exception e) {
				throw new SQLException("Convert Date Error! Date Value:" + date
						+ " Format:" + column.getDateFormat());
			}

		}

		if (type == Timestamp.class) {

			return date;

		}

		if (type == java.sql.Date.class) {

			return new java.sql.Date(date.getTime());

		}

		if (type == Date.class) {

			return new Date(date.getTime());

		}

		return date;
	}

	protected Object getWasNullFilter(Object value) {
		return value;
	}

	public static void main(String[] args) {
		System.out.println(ClassUtils.isAssignable(java.sql.Timestamp.class,
				Date.class));
	}
}
