package com.rapid.j2ee.framework.orm.medium.interceptor;

import java.beans.BeanInfo;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Date;
import java.util.List;

import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

import com.rapid.j2ee.framework.core.memorycache.BusinessServiceStaticMemoryCache;
import com.rapid.j2ee.framework.core.reflect.BeanUtils;
import com.rapid.j2ee.framework.core.utils.ClassUtils;
import com.rapid.j2ee.framework.core.utils.DateTimeUtils;
import com.rapid.j2ee.framework.core.utils.TypeChecker;
import com.rapid.j2ee.framework.core.utils.support.DateTimeFormat;
import com.rapid.j2ee.framework.mvc.security.domain.WebUser;
import com.rapid.j2ee.framework.mvc.security.domain.WebUserAccountIdField;
import com.rapid.j2ee.framework.mvc.security.utils.MvcSecurityActionContextUtils;
import com.rapid.j2ee.framework.orm.medium.annotation.Creator;
import com.rapid.j2ee.framework.orm.medium.annotation.CreatorDate;
import com.rapid.j2ee.framework.orm.medium.annotation.CreatorInform;
import com.rapid.j2ee.framework.orm.medium.annotation.SubmitDate;
import com.rapid.j2ee.framework.orm.medium.annotation.Submitter;
import com.rapid.j2ee.framework.orm.medium.annotation.SubmitterInform;
import com.rapid.j2ee.framework.orm.medium.annotation.Updater;
import com.rapid.j2ee.framework.orm.medium.annotation.UpdaterDate;
import com.rapid.j2ee.framework.orm.medium.annotation.UpdaterInform;
import com.rapid.j2ee.framework.orm.medium.field.PersistentBeanTableDefinition;
import com.rapid.j2ee.framework.orm.medium.mapper.PersistentBeanTableDefinitionRegistry;

public class MediumTransactionOperatorTrackMapperInterceptor implements
		MediumSessionMapperOperationInterceptor, InitializingBean {

	public void before(String operation, Object bean) {

		WebUser webUser = MvcSecurityActionContextUtils.getWebUser();

		if (TypeChecker.isNull(webUser)) {
			return;
		}

		this.setOperatorTrack(webUser, bean, Submitter.class,
				SubmitterInform.class, SubmitDate.class);

		if ("insert".equalsIgnoreCase(operation)) {

			this.setOperatorTrack(webUser, bean, Creator.class,
					CreatorInform.class, CreatorDate.class);

			return;
		}

		this.setOperatorTrack(webUser, bean, Updater.class,
				UpdaterInform.class, UpdaterDate.class);
	}

	protected void setOperatorTrack(WebUser webUser, Object bean,
			Class<? extends Annotation> operatorClass,
			Class<? extends Annotation> operatorInfoClass,
			Class<? extends Annotation> operationDateClass) {

		if (TypeChecker.isNull(webUser)) {
			System.out.println("Warning.................. No web user!!!");
			return;
		}

		PersistentBeanTableDefinition persistentBeanTableDefinition = PersistentBeanTableDefinitionRegistry
				.getInstance()
				.getPersistentBeanTableDefinition(bean.getClass());

		List<Field> fields = persistentBeanTableDefinition
				.getFieldByAnnotations(operatorClass);

		for (Field field : fields) {
			this.setWebUserAccountId(bean, field, webUser);
		}

		fields = persistentBeanTableDefinition
				.getFieldByAnnotations(operatorInfoClass);

		for (Field field : fields) {

			BeanUtils.setProperty(bean, field.getName(), BeanUtils
					.getPropertyObject(webUser, this.getTrackerInformFieldName(
							operatorInfoClass, field)));

		}

		fields = persistentBeanTableDefinition
				.getFieldByAnnotations(operationDateClass);

		for (Field field : fields) {

			if (!this.isSetFieldValueDateValid(bean, field, operationDateClass)) {
				continue;
			}

			Object sysDate = DateTimeUtils.getCurrentDate();

			if (field.getType() == String.class) {
				sysDate = DateTimeUtils
						.getCurrentWebDate(DateTimeFormat.YYYY_MM_DD_HH_MM_SS);
			}

			BeanUtils.setProperty(bean, field.getName(), sysDate);

		}

	}

	private void setWebUserAccountId(Object bean, Field field, WebUser webUser) {

		if (webUserAccountIdAnnotation == false) {

			BeanUtils
					.setProperty(bean, field.getName(), webUser.getAccountId());

			return;
		}

		if (!businessServiceStaticMemoryCache.hasCachedValue(webUser.getClass()
				.getName())) {

			Field accountIdField = ClassUtils.getFieldByAnnotation(webUser
					.getClass(), WebUserAccountIdField.class);

			Assert.notNull(accountIdField);

			businessServiceStaticMemoryCache.storeValue(webUser.getClass()
					.getName(), accountIdField);

		}

		Field accountIdField = (Field) businessServiceStaticMemoryCache
				.getValueCached(webUser.getClass().getName());

		BeanUtils.setProperty(bean, field.getName(), BeanUtils
				.getPropertyObject(webUser, accountIdField.getName()));

	}

	private boolean isSetFieldValueDateValid(Object bean, Field field,
			Class<? extends Annotation> operationDateClass) {

		if (operationDateClass != CreatorDate.class) {
			return true;
		}

		return TypeChecker.isNull(BeanUtils.getPropertyObject(bean, field
				.getName()));

	}

	private String getTrackerInformFieldName(
			Class<? extends Annotation> operatorInfoClass, Field field) {

		Annotation operatorAnno = (field.getAnnotation(operatorInfoClass));

		if (operatorInfoClass == CreatorInform.class) {
			return ((CreatorInform) operatorAnno).fieldNameOfWebUser();
		}

		if (operatorInfoClass == UpdaterInform.class) {
			return ((UpdaterInform) operatorAnno).fieldNameOfWebUser();
		}

		return ((SubmitterInform) operatorAnno).fieldNameOfWebUser();

	}

	public void setWebUserAccountIdAnnotation(boolean webUserAccountIdAnnotation) {
		this.webUserAccountIdAnnotation = webUserAccountIdAnnotation;
	}

	public void setBusinessServiceStaticMemoryCache(
			BusinessServiceStaticMemoryCache businessServiceStaticMemoryCache) {
		this.businessServiceStaticMemoryCache = businessServiceStaticMemoryCache;
	}

	public void afterPropertiesSet() throws Exception {

		if (webUserAccountIdAnnotation) {
			Assert.notNull(businessServiceStaticMemoryCache);
		}
	}

	private boolean webUserAccountIdAnnotation = false;

	private BusinessServiceStaticMemoryCache businessServiceStaticMemoryCache;

}
