package com.rapid.j2ee.framework.orm.medium.javabeanscript;

import com.rapid.j2ee.framework.core.utils.StringUtils;

public class MediumBeanTableGeneralRenameJavaClass implements
		MediumBeanTableRenameJavaClass {

	public String rename(String tableName) {

		tableName = StringUtils.replace(tableName, "-", "_");

		String removePrefix = StringUtils.substringBefore(tableName, "_")
				.toLowerCase();

		tableName = tableName.toLowerCase();

		if (tableName.startsWith(removePrefix)) {
			tableName = tableName.substring(removePrefix.length() + 1);
		}

		StringBuffer newTableName = new StringBuffer(tableName.length());

		boolean startUpperCase = false;

		for (int i = 0; i < tableName.length(); i++) {
			if (i == 0) {
				newTableName.append(String.valueOf(tableName.charAt(i))
						.toUpperCase());
				continue;
			}

			if (tableName.charAt(i) == '-' || tableName.charAt(i) == '_') {
				startUpperCase = true;
				continue;
			}

			newTableName.append(startUpperCase ? String.valueOf(
					tableName.charAt(i)).toUpperCase() : tableName.charAt(i));

			startUpperCase = false;
		}

		return newTableName.toString();
	}

}
