package com.rapid.j2ee.framework.orm.medium.javabeanscript;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

import com.rapid.j2ee.framework.core.charset.CharsetType;
import com.rapid.j2ee.framework.core.charset.Charsets;
import com.rapid.j2ee.framework.core.io.file.FileWriter;
import com.rapid.j2ee.framework.core.utils.FileUtils;
import com.rapid.j2ee.framework.core.utils.StringUtils;
import com.rapid.j2ee.framework.orm.medium.mapper.MediumPersistentBeanScanMapper;
import com.rapid.j2ee.framework.orm.medium.mapper.MediumPersistentBeanSmartScanMapper;

public class MediumPersistentBeanJavaSourceGenerator implements
		InitializingBean {

	public void export() {

		if (!this.isExportPathValid()) {

			return;
		}

		for (String targetTableName : targetTableNames) {
			exportJavaSourceFile(targetTableName);
		}
	}

	private boolean isExportPathValid() {
		return new File(this.exportPath).exists();
	}

	private void exportJavaSourceFile(String tableName) {

		String javaSource = mediumPersistentBeanScanMapper
				.exportJavaSourceText(catalog, schema, tableName);

		javaSource = StringUtils.replace(javaSource, tableName,
				mediumPersistenceBeanScriptRename.rename(tableName));

		FileWriter fw = new FileWriter(new File(this.exportPath,
				mediumPersistenceBeanScriptRename.rename(tableName) + ".java"),
				Charsets.getCharsetInstance(CharsetType.UTF_8));
		fw.writeln(StringUtils.replaceAll(StringUtils.replaceAll(StringUtils
				.trimToEmpty(javaSourceHeader), ";", ";\n"),"import","\nimport"));
		fw.writeln(javaSource);
		fw.flush();
		fw.close();

	}

	public void setMediumPersistenceBeanScriptRename(
			MediumBeanTableRenameJavaClass mediumPersistenceBeanScriptRename) {
		this.mediumPersistenceBeanScriptRename = mediumPersistenceBeanScriptRename;
	}

	public void setExportPath(String exportPath) {
		this.exportPath = exportPath;
	}

	public MediumPersistentBeanJavaSourceGenerator() {
		targetTableNames = new ArrayList<String>();
	}

	public void setMediumPersistentBeanScanMapper(
			MediumPersistentBeanScanMapper mediumPersistentBeanScanMapper) {
		this.mediumPersistentBeanScanMapper = mediumPersistentBeanScanMapper;
	}

	public void setMediumPersistentBeanSmartScanMapper(
			MediumPersistentBeanSmartScanMapper mediumPersistentBeanSmartScanMapper) {
		this.mediumPersistentBeanScanMapper = mediumPersistentBeanSmartScanMapper
				.getMediumPersistentBeanScanMapper();
	}

	public void setTargetTableNames(List<String> targetTableNames) {
		this.targetTableNames = targetTableNames;
	}

	public void afterPropertiesSet() throws Exception {

		Assert.hasText(this.exportPath, "Please provide a export path!");

		Assert.notNull(mediumPersistentBeanScanMapper,
				"Please provide a medium persistence bean scan mapper!");

		FileUtils.makeDir(this.exportPath);

	}

	public void setCatalog(String catalog) {
		this.catalog = catalog;
	}

	public void setSchema(String schema) {
		this.schema = schema;
	}

	public void setJavaSourceHeader(String javaSourceHeader) {
		this.javaSourceHeader = javaSourceHeader;
	}

	private List<String> targetTableNames;

	private MediumPersistentBeanScanMapper mediumPersistentBeanScanMapper;

	private String exportPath;

	private String catalog;

	private String schema;

	private String javaSourceHeader;

	private MediumBeanTableRenameJavaClass mediumPersistenceBeanScriptRename = new MediumBeanTableGeneralRenameJavaClass();

}
