package com.rapid.j2ee.framework.orm.medium.mapper;

import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.rapid.j2ee.framework.orm.medium.table.TableColumn;

public abstract class AbstractColumnFieldMapper implements ColumnFieldMapper {

	public TableColumn getColumnName(String table, List<TableColumn> columns,
			String fieldName) {

		for (TableColumn column : columns) {
			if (isMatched(column.getColumnName(), fieldName)) {
				return column;
			}
		}

		logger.error("The Table [" + table + "] contains column [ " + columns
				+ "]");

		throw new IllegalArgumentException("The field [" + fieldName
				+ "] cannot be mapped in any column of the table [" + table
				+ "]");

	}

	protected abstract boolean isMatched(String columnName, String fieldName);

	private Log logger = LogFactory.getLog(this.getClass());

}
