package com.rapid.j2ee.framework.orm.medium.mapper;

import java.lang.reflect.Field;

import org.apache.commons.lang.builder.ToStringBuilder;
import org.springframework.util.Assert;

import com.rapid.j2ee.framework.core.reflect.ConstructorUtils;
import com.rapid.j2ee.framework.core.utils.ClassUtils;
import com.rapid.j2ee.framework.core.utils.StringUtils;
import com.rapid.j2ee.framework.core.utils.TypeChecker;
import com.rapid.j2ee.framework.orm.medium.annotation.Column;
import com.rapid.j2ee.framework.orm.medium.annotation.Table;
import com.rapid.j2ee.framework.orm.medium.annotation.TableCopy;
import com.rapid.j2ee.framework.orm.medium.configurer.MeduimMapperConfigurer;
import com.rapid.j2ee.framework.orm.medium.field.FieldColumn;
import com.rapid.j2ee.framework.orm.medium.field.PersistentBeanTableDefinition;
import com.rapid.j2ee.framework.orm.medium.table.TableColumn;
import com.rapid.j2ee.framework.orm.medium.table.TableConfigureJdbcTemplate;

public class MediumPersistentBeanParser {

	private PersistentBeanTableDefinition table;

	private String category;

	private String schema;

	private Class tableClass;

	private TableConfigureJdbcTemplate tableConfigureJdbcTemplate;

	private Table tableAnnotation;

	private TableCopy tableCopyAnnotation;

	private ColumnFieldMapper columnFieldMapper = null;

	private MeduimMapperConfigurer configure;

	public MediumPersistentBeanParser(String category, String schema,
			Class table) {
		this.category = category;
		this.schema = schema;
		this.tableClass = table;
		tableAnnotation = (Table) tableClass.getAnnotation(Table.class);

		tableCopyAnnotation = (TableCopy) tableClass
				.getAnnotation(TableCopy.class);
	}

	public TableCopy getTableCopyAnnotation() {
		return tableCopyAnnotation;
	}

	public void setTableConfigureJdbcTemplate(
			TableConfigureJdbcTemplate tableConfigureJdbcTemplate) {
		this.tableConfigureJdbcTemplate = tableConfigureJdbcTemplate;
	}

	public void setMeduimMapperConfigurer(MeduimMapperConfigurer configure) {
		this.configure = configure;
	}

	private void parseColumnFieldMapper() {

		com.rapid.j2ee.framework.orm.medium.annotation.ColumnFieldMapper mapperAnnotation = (com.rapid.j2ee.framework.orm.medium.annotation.ColumnFieldMapper) tableClass
				.getAnnotation(ColumnFieldMapper.class);

		columnFieldMapper = this.configure.getColumnFieldMapper();

		if (!TypeChecker.isNull(mapperAnnotation)) {
			columnFieldMapper = (ColumnFieldMapper) ConstructorUtils
					.newCacheInstance(mapperAnnotation.value());
		}

	}

	public PersistentBeanTableDefinition weaveMapper() {

		parseColumnFieldMapper();

		parseTableFieldColumns();

		this.table.initializeBean();

		return this.table;
	}

	public static String getRealTableName(Table tableAnnotation) {

		String tableName = tableAnnotation.value();

		if (System.getProperties().containsKey(
				"MediumPersistence.Replace." + tableName.toUpperCase())) {
			return System.getProperties().getProperty(
					"MediumPersistence.Replace." + tableName.toUpperCase());
		}

		return tableName;
	}

	private void parseTableFieldColumns() {

		Assert.notNull(this.tableAnnotation,
				"Table Annotation must be configured on table class "
						+ tableClass.getName());

		com.rapid.j2ee.framework.orm.medium.table.Table dbTable = tableConfigureJdbcTemplate
				.getTable(tableClass, category, schema,
						getRealTableName(this.tableAnnotation), this.configure
								.getTableColumnTypeMapper());

		Field[] fs = ClassUtils.getFieldsByAnnotation(this.tableClass,
				Column.class);

		table = new PersistentBeanTableDefinition(this.tableClass, schema,
				tableAnnotation, tableCopyAnnotation, fs.length);

		for (Field f : fs) {

			TableColumn column = this.columnFieldMapper.getColumnName(dbTable
					.getSchemaTable(), dbTable.getTableColumns(), StringUtils
					.trimToEmpty(((Column) f.getAnnotation(Column.class))
							.dbTableColumn(), f.getName()));

			table.addFieldColumn(new FieldColumn(this.configure, f, column));
		}

	}

	public String toString() {
		return ToStringBuilder.reflectionToString(this);
	}

}
