package com.rapid.j2ee.framework.orm.medium.mapper;

import java.util.Set;

import javax.sql.DataSource;

import org.springframework.core.io.Resource;

import com.rapid.j2ee.framework.core.reflect.BeanUtils;
import com.rapid.j2ee.framework.core.utils.ResolverUtils;
import com.rapid.j2ee.framework.core.utils.TypeChecker;
import com.rapid.j2ee.framework.orm.medium.annotation.Table;
import com.rapid.j2ee.framework.orm.medium.configurer.MeduimMapperConfigurer;
import com.rapid.j2ee.framework.orm.medium.table.TableConfigureJdbcTemplate;
import com.rapid.j2ee.framework.orm.medium.table.xml.TableConfigureStorageAccessor;

public class MediumPersistentBeanScanMapper extends
		MediumPersistentBeanScanMapperConfigurer {

	private String mapperLocation;

	private Resource mapperLocationResource;

	public MediumPersistentBeanScanMapper() {

	}

	private void prepare() {

		tableConfigureJdbcTemplate = new TableConfigureJdbcTemplate();

		BeanUtils.copy(this, tableConfigureJdbcTemplate, true);

		tableConfigureJdbcTemplate
				.setTableConfigureStorageAccessor(this.tableConfigureStorageAccessor);

		tableConfigureJdbcTemplate
				.setColumnTypeToJavaSourceTypeMapper(columnTypeToJavaSourceTypeMapper);

		tableConfigureJdbcTemplate.setDataSource(this.dataSource);

		mapperConfigurer = new MeduimMapperConfigurer(this.mapperLocation,
				mapperLocationResource);

	}

	public void scan() {

		prepare();

		doPackageScan();

	}

	public String exportJavaSourceText(String catalog, String schema,
			String tableName) {
		return tableConfigureJdbcTemplate.getTableOrmJavaSource(catalog,
				schema, tableName, this.mapperConfigurer
						.getTableColumnTypeMapper(), "\n");
	}

	public String exportJavaSourceHtml(String catalog, String schema,
			String tableName) {
		return tableConfigureJdbcTemplate.getTableOrmJavaSource(catalog,
				schema, tableName, this.mapperConfigurer
						.getTableColumnTypeMapper(), "</br>");
	}

	public void close() {

		PersistentBeanTableDefinitionRegistry.getInstance().clear();

		mapperConfigurer.clear();
	}

	private void doPackageScan() {

		if (TypeChecker.isEmpty(packages)) {
			return;
		}

		Set<Class> sets = ResolverUtils.findAnnotationMark(Table.class,
				packages);

		for (Class clz : sets) {
			parsePersistentBeanTable(clz);
		}
	}

	private void parsePersistentBeanTable(Class clz) {

		MediumPersistentBeanParser parser = new MediumPersistentBeanParser(
				this.category, this.schema, clz);

		parser.setMeduimMapperConfigurer(this.mapperConfigurer);
		parser.setTableConfigureJdbcTemplate(tableConfigureJdbcTemplate);

		PersistentBeanTableDefinitionRegistry.getInstance().registry(
				clz,
				parser.weaveMapper()
						.setMeduimMapperConfigurer(mapperConfigurer));

		PersistentBeanTableDefinitionRegistry.getInstance()
				.setMeduimMapperConfigurer(mapperConfigurer);

	}

	public void setCategory(String category) {
		this.category = category;
	}

	public void setPackages(String[] packageNames) {
		this.packages = packageNames;
	}

	public void setSchema(String schema) {
		this.schema = schema;
	}

	public void setDataSource(DataSource source) {
		this.dataSource = source;
	}

	public void setMapperLocation(String mapperLocation) {
		this.mapperLocation = mapperLocation;
	}

	public void setMapperLocationResource(Resource mapperLocationResource) {
		this.mapperLocationResource = mapperLocationResource;
	}

}
