package com.rapid.j2ee.framework.orm.medium.mapper;

import java.util.Arrays;

import org.springframework.core.io.Resource;
import org.springframework.util.Assert;

import com.rapid.j2ee.framework.core.exception.ExceptionUtils;
import com.rapid.j2ee.framework.core.io.xml.XNode;
import com.rapid.j2ee.framework.core.io.xml.XPathParser;
import com.rapid.j2ee.framework.core.reflect.BeanUtils;
import com.rapid.j2ee.framework.core.utils.ResourceUtils;
import com.rapid.j2ee.framework.core.utils.StringUtils;
import com.rapid.j2ee.framework.core.utils.TypeChecker;

public class MediumPersistentBeanSmartScanMapper extends
		MediumPersistentBeanScanMapperConfigurer {

	public MediumPersistentBeanSmartScanMapper() {

	}

	public void scan() {

		this.initializeMapperBean();

		this.setMediumPersistentBeanMapperLocation();

		mediumPersistentBeanScanMapper.scan();
	}

	public void close() {

		mediumPersistentBeanScanMapper.close();
	}

	private void initializeMapperBean() {

		mediumPersistentBeanScanMapper = new MediumPersistentBeanScanMapper();

		BeanUtils.copy(this, mediumPersistentBeanScanMapper, true);

		System.out.println("Medium Persistence Package ============== "
				+ Arrays.toString(this.getPackages()));

	}

	private void setMediumPersistentBeanMapperLocation() {

		Assert.hasText(this.mapperPath);

		Resource[] resources = ResourceUtils.getResources(this.mapperPath);

		Assert.noNullElements(resources);

		for (Resource resource : resources) {

			if (this.matchDatabaseType(resource)) {

				mediumPersistentBeanScanMapper
						.setMapperLocationResource(resource);

				System.out.println("Medium Persistence Mapper ============== "
						+ resource);

				return;
			}
		}

	}

	private boolean matchDatabaseType(Resource resource) {

		try {
			XPathParser xParser = new XPathParser(resource.getInputStream(),
					"utf-8");

			XNode node = xParser.evalNode("configuration");

			if (TypeChecker.isNull(node)) {
				return false;
			}

			return StringUtils.equalsIgnoreCase(
					node.getStringAttribute("type"), this.databaseType);

		} catch (Exception e) {

			throw ExceptionUtils.convertThrowableToBaseException(e);
		}
	}

	public void setDatabaseType(String databaseType) {
		this.databaseType = databaseType;
	}

	public void setMapperPath(String mapperPath) {
		this.mapperPath = mapperPath;
	}

	public MediumPersistentBeanScanMapper getMediumPersistentBeanScanMapper() {
		return mediumPersistentBeanScanMapper;
	}

	private String mapperPath;

	private String databaseType;

	private MediumPersistentBeanScanMapper mediumPersistentBeanScanMapper;

}
