package com.rapid.j2ee.framework.orm.medium.mapper;

import java.util.HashMap;
import java.util.Map;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.rapid.j2ee.framework.core.utils.StringUtils;
import com.rapid.j2ee.framework.orm.medium.annotation.Table;
import com.rapid.j2ee.framework.orm.medium.configurer.MeduimMapperConfigurer;
import com.rapid.j2ee.framework.orm.medium.field.PersistentBeanTableDefinition;

public class PersistentBeanTableDefinitionRegistry {

	private static PersistentBeanTableDefinitionRegistry INSTANCE = new PersistentBeanTableDefinitionRegistry();

	private Map<String, PersistentBeanTableDefinition> persistentBeanTableDefinitions = null;

	private MeduimMapperConfigurer meduimMapperConfigurer;

	private PersistentBeanTableDefinitionRegistry() {
		persistentBeanTableDefinitions = new HashMap<String, PersistentBeanTableDefinition>();
	}

	public static PersistentBeanTableDefinitionRegistry getInstance() {
		return INSTANCE;

	}

	public void setMeduimMapperConfigurer(
			MeduimMapperConfigurer meduimMapperConfigurer) {
		this.meduimMapperConfigurer = meduimMapperConfigurer;
	}

	public MeduimMapperConfigurer getMeduimMapperConfigurer() {
		return meduimMapperConfigurer;
	}

	public synchronized void registry(Class clz,
			PersistentBeanTableDefinition def) {

		String name = getBeanKey(clz);

		log
				.info("Persistence ORMapper Medium has registryed Table Definitation : "
						+ clz.getSimpleName() + " For Table Name:" + name);

		persistentBeanTableDefinitions.put(name, def);
	}

	public PersistentBeanTableDefinition getPersistentBeanTableDefinition(
			Class clz) {

		String name = getBeanKey(clz);

		if (!persistentBeanTableDefinitions.containsKey(name)) {
			throw new IllegalArgumentException(
					"The class bean mapper is not found! Class : "
							+ clz.getName() + " / Name: " + name);
		}

		return persistentBeanTableDefinitions.get(name);
	}

	public boolean exits(Class clz) {

		return persistentBeanTableDefinitions.containsKey(getBeanKey(clz));
	}

	public String getBeanKey(Class clz) {
		return StringUtils.trimToEmpty(
				MediumPersistentBeanParser.getRealTableName((Table) clz
						.getAnnotation(Table.class))).toUpperCase();
	}

	public void clear() {

		persistentBeanTableDefinitions.clear();

		persistentBeanTableDefinitions = null;
	}

	private Log log = LogFactory
			.getLog(PersistentBeanTableDefinitionRegistry.class);

}
