package com.rapid.j2ee.framework.orm.medium.setter;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;

import com.rapid.j2ee.framework.core.reflect.BeanUtils;
import com.rapid.j2ee.framework.core.utils.TypeChecker;
import com.rapid.j2ee.framework.core.utils.UUIDGenerator;
import com.rapid.j2ee.framework.orm.medium.MediumSessionOperations;
import com.rapid.j2ee.framework.orm.medium.configurer.MeduimMapperConfigurer;
import com.rapid.j2ee.framework.orm.medium.field.FieldColumn;
import com.rapid.j2ee.framework.orm.medium.field.PersistentBeanTableDefinition;
import com.rapid.j2ee.framework.orm.medium.interceptor.MediumModelInterceptor;
import com.rapid.j2ee.framework.orm.medium.interceptor.MediumSessionMapperOperationInterceptor;
import com.rapid.j2ee.framework.orm.medium.mapper.PersistentBeanTableDefinitionRegistry;

public class MediumSessionBatchPreparedStatementSetterImpl implements
		MediumSessionBatchPreparedStatementSetter {

	private List beans;

	private PersistentBeanTableDefinition definition;

	private MeduimMapperConfigurer configurer;

	private int operationType;

	private MediumSessionMapperOperationInterceptor mediumSessionMapperOperationInterceptor;

	public MediumSessionBatchPreparedStatementSetterImpl(
			MediumSessionMapperOperationInterceptor mediumSessionMapperOperationInterceptor,
			List beans, Class beanClz, int operationType) {
		this.mediumSessionMapperOperationInterceptor = mediumSessionMapperOperationInterceptor;
		this.beans = beans;
		definition = PersistentBeanTableDefinitionRegistry.getInstance()
				.getPersistentBeanTableDefinition(beanClz);
		configurer = this.definition.getMapperConfigurer();
		this.operationType = operationType;

	}

	public String getExecutedSQL() {

		if (operationType == MediumSessionOperations.INSERT) {

			return definition.getInsertSQL();
		}

		throw new UnsupportedOperationException(
				"Support Operation Type in MediumSessionBatchPreparedStatementSetterImpl:"
						+ this.operationType);

	}

	public void setValues(PreparedStatement statement, int index)
			throws SQLException {

		if (operationType == MediumSessionOperations.INSERT) {

			setInsertValuesPerBean(statement, this.beans.get(index));

			return;
		}

	}

	private void setInsertValuesPerBean(PreparedStatement statement, Object bean)
			throws SQLException {

		mediumSessionMapperOperationInterceptor.before("insert", bean);

		setAutowirePrimaryKeyValues(bean);

		if (bean instanceof MediumModelInterceptor) {
			((MediumModelInterceptor) bean).before("insert");
		}

		List<FieldColumn> columns = definition.getFieldColumns();

		int index = 0;

		for (int i = 0, j = columns.size(); i < j; i++) {

			if (columns.get(i).isAutoIncreaseId()) {
				continue;
			}

			configurer.getInPreparedStatementAcceptor(columns.get(i))
					.setPrepareStatement(this.operationType, statement, bean,
							columns.get(i), index++);

		}

		if (bean instanceof MediumModelInterceptor) {
			((MediumModelInterceptor) bean).after("insert", -1);
		}

	}

	private boolean containPrimaryKeyValues(Object bean) {

		List<FieldColumn> columns = definition.getFieldColumns();

		for (int i = 0, j = columns.size(); i < j; i++) {

			FieldColumn column = columns.get(i);

			if (!column.isPrimaryKey(operationType)) {
				continue;
			}

			if (isNullPrimaryKey(bean, column)) {
				return false;
			}
		}

		return true;

	}

	private boolean isNullPrimaryKey(Object bean, FieldColumn column) {

		Object value = BeanUtils.getPropertyObject(bean, column.getField()
				.getName());

		if (TypeChecker.isNull(value)) {
			return true;
		}

		if (value instanceof String) {
			return TypeChecker.isEmpty((String) value);
		}

		return false;
	}

	private void setAutowirePrimaryKeyValues(Object bean) {

		if (containPrimaryKeyValues(bean)) {
			return;
		}

		String beanClassName = bean.getClass().getSimpleName();

		List<FieldColumn> columns = definition.getFieldColumns();

		for (int i = 0, j = columns.size(); i < j; i++) {

			FieldColumn column = columns.get(i);

			if (!column.isPrimaryKey(operationType)) {
				continue;
			}

			if (isNullPrimaryKey(bean, column)) {

				BeanUtils.setProperty(bean, column.getField().getName(),
						UUIDGenerator.nextUUID(beanClassName + "_{uuid}"));
			}

		}

	}

	public int getBatchSize() {

		return beans.size();
	}

}
