package com.rapid.j2ee.framework.orm.medium.setter;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.rapid.j2ee.framework.orm.medium.MediumSessionOperations;
import com.rapid.j2ee.framework.orm.medium.configurer.MeduimMapperConfigurer;
import com.rapid.j2ee.framework.orm.medium.field.FieldColumn;
import com.rapid.j2ee.framework.orm.medium.field.PersistentBeanTableDefinition;
import com.rapid.j2ee.framework.orm.medium.filter.ColumnFieldFilter;
import com.rapid.j2ee.framework.orm.medium.interceptor.MediumMapperSqlInterceptor;
import com.rapid.j2ee.framework.orm.medium.mapper.PersistentBeanTableDefinitionRegistry;

public class MediumSessionPreparedStatementPrimaryKeySetter implements
		MediumSessionPreparedStatementSetter {

	private Object value;

	private PersistentBeanTableDefinition definition;

	private MeduimMapperConfigurer configurer;

	private int operationType;

	public MediumSessionPreparedStatementPrimaryKeySetter(int operationType,
			Class clz, Object value) {

		this.value = value;
		definition = PersistentBeanTableDefinitionRegistry.getInstance()
				.getPersistentBeanTableDefinition(clz);
		configurer = this.definition.getMapperConfigurer();
		this.operationType = operationType;

	}

	public String getExecutedSQL() {
		return getExecutedSQL(MediumMapperSqlInterceptor.INTERCEPTOR);
	}

	public String getExecutedSQL(MediumMapperSqlInterceptor sqlInterceptor) {

		if (operationType == MediumSessionOperations.DELETE) {
			return sqlInterceptor.reviseSQL(definition.getDeleteSQL());
		}

		if (operationType == MediumSessionOperations.SEARTH_BY_PK
				|| operationType == MediumSessionOperations.QUERY_LIST_BY_PK) {
			return sqlInterceptor.reviseSQL(definition
					.getFindOrQuerySQL(operationType));
		}

		if (operationType == MediumSessionOperations.SEARTH_COUNTS_BY_PK) {
			return sqlInterceptor.reviseSQL(definition.getFindCountsSQL());
		}

		throw new UnsupportedOperationException("Support Operation Type:"
				+ this.operationType);

	}

	public void setValues(PreparedStatement statement) throws SQLException {

		List<FieldColumn> columns = definition.getFieldColumns();

		int index = 0;

		for (int i = 0, j = columns.size(); i < j; i++) {

			FieldColumn column = columns.get(i);

			if (!column.isPrimaryKey(operationType)) {
				continue;
			}

			Logger.info("Index = " + index + " Column:"
					+ column.getColumn().getColumnName() + " Value:" + value);

			configurer.getInPreparedStatementAcceptor(columns.get(i))
					.setPrepareStatementPrimaryKeyValue(this.operationType,
							statement, value, columns.get(i), index++);

		}

	}

	public boolean containPrimaryKeyValues() {

		throw new UnsupportedOperationException(
				"Unsupport containPrimarykeyValues method!");
	}

	public void setAutowirePrimaryKeyValues() {
		throw new UnsupportedOperationException(
				"Unsupport setAutowirePrimaryKeyValues method!");

	}

	public void setColumnFieldFilter(ColumnFieldFilter columnFieldFilter) {
		throw new UnsupportedOperationException(
				"Unsupport setColumnFieldFilter method!");

	}

	public void addMeduimMapperSQLInterceptor(
			MediumMapperSqlInterceptor sqlInterceptor) {
		throw new UnsupportedOperationException(
				"Unsupport addMeduimMapperSQLInterceptor method!");

	}

	private static final Log Logger = LogFactory
			.getLog(MediumSessionPreparedStatementPrimaryKeySetter.class);

}
