package com.rapid.j2ee.framework.orm.medium.setter;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;

import com.rapid.j2ee.framework.core.reflect.BeanUtils;
import com.rapid.j2ee.framework.core.reflect.InvokeUtils;
import com.rapid.j2ee.framework.core.utils.ClassUtils;
import com.rapid.j2ee.framework.core.utils.DateTimeUtils;
import com.rapid.j2ee.framework.core.utils.StringUtils;
import com.rapid.j2ee.framework.core.utils.TypeChecker;
import com.rapid.j2ee.framework.core.utils.UUIDGenerator;
import com.rapid.j2ee.framework.core.utils.support.DateTimeFormat;
import com.rapid.j2ee.framework.orm.medium.MediumQueryAnnotationAcceptor;
import com.rapid.j2ee.framework.orm.medium.MediumSessionOperations;
import com.rapid.j2ee.framework.orm.medium.annotation.Column;
import com.rapid.j2ee.framework.orm.medium.configurer.MeduimMapperConfigurer;
import com.rapid.j2ee.framework.orm.medium.field.FieldColumn;
import com.rapid.j2ee.framework.orm.medium.field.PersistentBeanTableDefinition;
import com.rapid.j2ee.framework.orm.medium.filter.ColumnFieldFilter;
import com.rapid.j2ee.framework.orm.medium.filter.UpdateSetColumnFieldFilter;
import com.rapid.j2ee.framework.orm.medium.interceptor.MediumMapperSqlInterceptor;
import com.rapid.j2ee.framework.orm.medium.mapper.PersistentBeanTableDefinitionRegistry;

public class MediumSessionPreparedStatementSetterImpl implements
		MediumSessionPreparedStatementSetter {

	private Object bean;

	private PersistentBeanTableDefinition definition;

	private MeduimMapperConfigurer configurer;

	private int operationType;

	private ColumnFieldFilter columnFieldFilter;

	private MediumMapperSqlInterceptor sqlInterceptor = MediumMapperSqlInterceptor.INTERCEPTOR;

	private int statementSetValueIndex = 0;

	public void setColumnFieldFilter(ColumnFieldFilter columnFieldFilter) {
		this.columnFieldFilter = columnFieldFilter;
	}

	public MediumSessionPreparedStatementSetterImpl(Object bean,
			int operationType) {
		this.bean = bean;
		definition = PersistentBeanTableDefinitionRegistry.getInstance()
				.getPersistentBeanTableDefinition(bean.getClass());
		configurer = this.definition.getMapperConfigurer();
		this.operationType = operationType;
		statementSetValueIndex = 0;

	}

	public MediumSessionPreparedStatementSetterImpl(Class clz, int operationType) {

		definition = PersistentBeanTableDefinitionRegistry.getInstance()
				.getPersistentBeanTableDefinition(clz);
		configurer = this.definition.getMapperConfigurer();
		this.operationType = operationType;
		statementSetValueIndex = 0;

	}

	public void addMeduimMapperSQLInterceptor(
			MediumMapperSqlInterceptor sqlInterceptor) {
		this.sqlInterceptor = sqlInterceptor;
	}

	public String getExecutedSQL() {

		if (operationType == MediumSessionOperations.QUERY_LIST_FOR_ALL) {

			return sqlInterceptor.reviseSQL(definition
					.getFindOrQuerySQL(operationType)
					+ definition.getOrderSql(operationType));
		}

		if (operationType == MediumSessionOperations.INSERT) {

			return sqlInterceptor.reviseSQL(definition.getInsertSQL());
		}

		if (operationType == MediumSessionOperations.UPDATE) {
			return sqlInterceptor.reviseSQL(definition
					.getUpdateSQL(this.columnFieldFilter));
		}

		if (operationType == MediumSessionOperations.DELETE) {
			return sqlInterceptor.reviseSQL(definition.getDeleteSQL(this.bean));
		}

		if (operationType == MediumSessionOperations.SEARTH_BY_PK) {
			return sqlInterceptor.reviseSQL(definition
					.getFindOrQuerySQL(operationType));
		}

		if (operationType == MediumSessionOperations.QUERY_LIST_BY_PK) {

			return sqlInterceptor.reviseSQL(definition.getFindOrQuerySQL(
					operationType, this.bean)
					+ definition.getOrderSql(operationType));
		}

		if (operationType == MediumSessionOperations.DELETE_BY_QUERY) {

			return sqlInterceptor.reviseSQL(definition.getDeleteQuerySQL(
					MediumSessionOperations.QUERY_LIST_BY_PK, this.bean));
		}

		if (operationType == MediumSessionOperations.QUERY_LIST_COUNT_BY_PK) {

			String sql = sqlInterceptor.reviseSQL(definition.getFindOrQuerySQL(
					MediumSessionOperations.QUERY_LIST_BY_PK, this.bean));

			return "SELECT COUNT(1) FROM "
					+ StringUtils.substringAfter(sql, "FROM");

		}

		if (operationType == MediumSessionOperations.SEARTH_COUNTS_BY_PK) {
			return sqlInterceptor.reviseSQL(definition.getFindCountsSQL());
		}

		if (operationType == MediumSessionOperations.COPY) {
			return sqlInterceptor.reviseSQL(definition.getCopySQL());
		}

		throw new UnsupportedOperationException("Support Operation Type:"
				+ this.operationType);

	}

	public void setValues(PreparedStatement statement) throws SQLException {

		try {

			if (operationType == MediumSessionOperations.QUERY_LIST_FOR_ALL) {
				return;
			}

			if (operationType == MediumSessionOperations.INSERT) {
				setInsertValues(statement);

				return;
			}

			if (operationType == MediumSessionOperations.UPDATE) {
				setUpdateValues(statement);

				return;
			}

			setWherePrimaryKeyValues(statement);

		} finally {
			sqlInterceptor.setValue(statement, statementSetValueIndex,
					this.bean);
		}

	}

	private void setInsertValues(PreparedStatement statement)
			throws SQLException {

		List<FieldColumn> columns = definition.getFieldColumns();

		int index = 0;

		for (int i = 0, j = columns.size(); i < j; i++) {

			if (columns.get(i).isAutoIncreaseId()) {
				continue;
			}

			this.setSystemDate(columns.get(i));

			configurer.getInPreparedStatementAcceptor(columns.get(i))
					.setPrepareStatement(this.operationType, statement, bean,
							columns.get(i), index++);
			statementSetValueIndex++;
		}
	}

	private void setSystemDate(FieldColumn fieldColumn) {

		if (!fieldColumn.isSysDate()
				|| !TypeChecker.isNull(InvokeUtils.getFieldValue(bean,
						fieldColumn.getField()))) {
			return;
		}

		if (ClassUtils.isAssignable(fieldColumn.getField().getType(),
				Date.class)) {

			InvokeUtils.setField(bean, fieldColumn.getField(), DateTimeUtils
					.getCurrentDate());

			return;

		}

		InvokeUtils.setField(bean, fieldColumn.getField(), DateTimeUtils
				.getCurrentWebDate(DateTimeFormat.getDateTimeFormat(fieldColumn
						.getField().getAnnotation(Column.class).dateFormat())));

	}

	public void setUpdateValues(PreparedStatement statement)
			throws SQLException {

		List<FieldColumn> columns = definition.getFieldColumns();

		int index = 0;

		for (int i = 0, j = columns.size(); i < j; i++) {
			FieldColumn column = columns.get(i);

			if (!definition.isPrimaryKeyUpdated()
					&& column.isPrimaryKey(operationType)) {
				continue;
			}

			if (columnFieldFilter instanceof UpdateSetColumnFieldFilter) {

				if (!((UpdateSetColumnFieldFilter) columnFieldFilter)
						.isSetColumnAvailable(column)) {
					continue;
				}
			}

			statementSetValueIndex++;

			configurer.getInPreparedStatementAcceptor(columns.get(i))
					.setPrepareStatement(this.operationType, statement, bean,
							columns.get(i), index++);

		}

		// Where ??
		for (int i = 0, j = columns.size(); i < j; i++) {
			FieldColumn column = columns.get(i);

			if (!column.isPrimaryKey(operationType)) {
				continue;
			}

			if (definition.isPrimaryKeyUpdated()
					&& bean instanceof MediumUpdatePrimaryKeyValues) {

				MediumUpdatePrimaryKeyValues updateValue = (MediumUpdatePrimaryKeyValues) bean;

				// PreparedStatement statement,
				// Object value, FieldColumn field, int index
				configurer.getInPreparedStatementAcceptor(columns.get(i))
						.setPrepareStatementPrimaryKeyValue(
								this.operationType,
								statement,
								updateValue.getWherePrimaryKeyValues(
										this.operationType, column.getField()
												.getName()), column, index++);

				continue;
			}

			configurer.getInPreparedStatementAcceptor(columns.get(i))
					.setPrepareStatement(this.operationType, statement, bean,
							columns.get(i), index++);

		}

	}

	public void setWherePrimaryKeyValues(PreparedStatement statement)
			throws SQLException {

		List<FieldColumn> columns = definition.getFieldColumns();

		int index = 0;

		boolean queryWhereSql = ((operationType == MediumSessionOperations.DELETE_BY_QUERY)
				|| (operationType == MediumSessionOperations.QUERY_LIST_BY_PK) || (operationType == MediumSessionOperations.QUERY_LIST_COUNT_BY_PK));

		for (int i = 0, j = columns.size(); i < j; i++) {

			FieldColumn column = columns.get(i);

			if (!column.isPrimaryKey(operationType)) {
				continue;
			}

			if (queryWhereSql && bean instanceof MediumQueryAnnotationAcceptor) {
				if (!((MediumQueryAnnotationAcceptor) bean).accept(column
						.getField())) {
					continue;
				}
			}

			if (isNullCheckable()) {

				if (definition.isNULL(bean, column)) {
					continue;
				}
			}

			if (operationType == MediumSessionOperations.DELETE) {
				if (definition.isNullForDelete(bean, column)) {
					continue;
				}
			}

			statementSetValueIndex++;

			if (definition.isPrimaryKeyUpdated()
					&& bean instanceof MediumUpdatePrimaryKeyValues) {

				MediumUpdatePrimaryKeyValues updateValue = (MediumUpdatePrimaryKeyValues) bean;

				// PreparedStatement statement,
				// Object value, FieldColumn field, int index
				configurer.getInPreparedStatementAcceptor(columns.get(i))
						.setPrepareStatementPrimaryKeyValue(
								this.operationType,
								statement,
								updateValue.getWherePrimaryKeyValues(
										this.operationType, column.getField()
												.getName()), column, index++);

				continue;
			}

			configurer.getInPreparedStatementAcceptor(columns.get(i))
					.setPrepareStatement(this.operationType, statement, bean,
							columns.get(i), index++);

		}

	}

	private boolean isNullCheckable() {
		return MediumSessionOperations.SEARTH_COUNTS_BY_PK != this.operationType
				&& MediumSessionOperations.SEARTH_BY_PK != this.operationType
				&& MediumSessionOperations.DELETE_BY_QUERY != this.operationType;
	}

	public boolean containPrimaryKeyValues() {

		List<FieldColumn> columns = definition.getFieldColumns();

		for (int i = 0, j = columns.size(); i < j; i++) {

			FieldColumn column = columns.get(i);

			if (!column.isPrimaryKey(operationType)) {
				continue;
			}

			if (isNullPrimaryKey(bean, column)) {
				return false;
			}
		}

		return true;

	}

	private boolean isNullPrimaryKey(Object bean, FieldColumn column) {

		Object value = BeanUtils.getPropertyObject(bean, column.getField()
				.getName());

		if (TypeChecker.isNull(value)) {
			return true;
		}

		if (value instanceof String) {
			return TypeChecker.isEmpty((String) value);
		}

		return false;
	}

	public void setAutowirePrimaryKeyValues() {

		List<FieldColumn> columns = definition.getFieldColumns();

		for (int i = 0, j = columns.size(); i < j; i++) {

			FieldColumn column = columns.get(i);

			if (!column.isPrimaryKey(operationType)) {
				continue;
			}

			if (column.getIdAnnotation().autoIncrease()) {
				continue;
			}

			if (isNullPrimaryKey(bean, column)) {
				BeanUtils.setProperty(bean, column.getField().getName(),
						UUIDGenerator.nextUUID());
			}

		}

	}
}
