package com.rapid.j2ee.framework.orm.medium.sqlinterceptor;

import java.sql.PreparedStatement;
import java.sql.SQLException;

import com.rapid.j2ee.framework.orm.medium.interceptor.MediumMapperSqlInterceptor;

public class MeduimMapperOraclePagerollSQLInterceptor implements
		MediumMapperSqlInterceptor, MeduimMapperPagerollSQLInterceptor {

	private int startRow;

	private int pageSize;

	private int totalCount;

	public MeduimMapperOraclePagerollSQLInterceptor(int startRow, int pageSize) {
		this.startRow = startRow;
		this.pageSize = pageSize;
	}

	public String reviseSQL(String sql) {

		return "SELECT * FROM (SELECT A.*, ROWNUM RN  FROM ( " + sql
				+ ") A WHERE ROWNUM <= ? ) WHERE RN >= ? ";
	}

	public void setValue(PreparedStatement statement, int currentIndex,
			Object bean) throws SQLException {

		currentIndex++;
		statement.setInt(currentIndex, this.startRow + this.pageSize - 1);
		currentIndex++;
		statement.setInt(currentIndex, this.startRow);
	}

	public void setTotalCount(int count) {
		this.totalCount = count;

	}

	public int getTotalCount() {

		return totalCount;
	}

	public boolean hasRecords() {

		return totalCount > (this.startRow + this.pageSize - 1);
	}

}
