package com.rapid.j2ee.framework.orm.medium.statement;

import java.sql.PreparedStatement;
import java.sql.SQLException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.rapid.j2ee.framework.core.reflect.BeanUtils;
import com.rapid.j2ee.framework.core.utils.StringUtils;
import com.rapid.j2ee.framework.core.utils.TypeChecker;
import com.rapid.j2ee.framework.orm.medium.MediumSessionMapperOperations;
import com.rapid.j2ee.framework.orm.medium.field.FieldColumn;

public abstract class AbstractInPreparedStatementAcceptor implements
		InPreparedStatementAcceptor {

	public void setPrepareStatementPrimaryKeyValue(int operationType,
			PreparedStatement statement, Object value, FieldColumn field,
			int index) throws SQLException {

		logger.info("Index: "
				+ (index + 1)
				+ " Column:"
				+ StringUtils.appendBehindCharToLength(field.getColumn()
						.getColumnName(), " ", 25) + " Value:" + value);

		setPrepareStatementValue(statement, field, index + 1, value);
	}

	public void setPrepareStatement(int operationType,
			PreparedStatement statement, Object bean, FieldColumn field,
			int index) throws SQLException {

		boolean defValueApplied = false;
		Object value = field.getValueBySqlLikeModePattern(operationType,
				BeanUtils.getPropertyObject(bean, field.getField().getName()));
		index = index + 1;
		setNVarchar(statement, index);
		if (TypeChecker.isNull(value)) {
			defValueApplied = true;
			value = field.getColumnDefaultValue();
		}
		if (setNull(statement, field, index, value)) {

			logger.info("Index: "
					+ index
					+ " Column:"
					+ StringUtils.appendBehindCharToLength(field.getColumn()
							.getColumnName(), " ", 25) + " Value is Null!");

			return;
		}
		logger.info("Index: "
				+ index
				+ " Column:"
				+ StringUtils.appendBehindCharToLength(field.getColumn()
						.getColumnName(), " ", 25) + " Value:" + value);

		try {
			if (defValueApplied) {

				setPrepareStatementDefaultValue(statement, field, index,
						(String) value);

				return;
			}
			setPrepareStatementValue(statement, field, index, value);
		} catch (SQLException e) {

			System.out.println("Index: "
					+ index
					+ " Column:"
					+ StringUtils.appendBehindCharToLength(field.getColumn()
							.getColumnName(), " ", 25) + " Value:" + value);
			throw e;
		}
	}

	protected void setNVarchar(PreparedStatement statement, int index) {

	}

	protected boolean setNull(PreparedStatement statement, FieldColumn field,
			int index, Object value) throws SQLException {

		if (isNull(field, value)) {

			statement.setNull(index, field.getColumn().getColumnType()
					.getSqlType());

			return true;
		}

		if (MediumSessionMapperOperations.NULL_VALUE_IDENTITY
				.equalsIgnoreCase(String.valueOf(value))) {
			return true;
		}

		return false;

	}

	protected abstract void setPrepareStatementDefaultValue(
			PreparedStatement statement, FieldColumn field, int index,
			String value) throws SQLException;

	protected abstract void setPrepareStatementValue(
			PreparedStatement statement, FieldColumn field, int index,
			Object value) throws SQLException;

	protected boolean isNull(FieldColumn field, Object value) {

		if (TypeChecker.isNull(value)) {
			return true;
		}

		if (field.getField().getType() == String.class
				&& TypeChecker.isEmpty((String) value)) {

			return !field.getColumn().supportsLike();

		}

		return false;
	}

	private final Log logger = LogFactory.getLog(this.getClass());
}
