package com.rapid.j2ee.framework.orm.medium.statement;

import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.SQLException;

import com.rapid.j2ee.framework.orm.medium.field.FieldColumn;

public class BigDecimalInPreparedStatementAcceptor extends
		AbstractInPreparedStatementAcceptor {

	@Override
	protected void setPrepareStatementValue(PreparedStatement statement,
			FieldColumn field, int index, Object value) throws SQLException {

		if (field.getField().getType() == int.class
				|| field.getField().getType() == Integer.class) {
			statement.setInt(index, (Integer) value);
			return;
		}

		if (field.getField().getType() == long.class
				|| field.getField().getType() == Long.class) {
			statement.setLong(index, (Long) value);
			return;
		}

		if (field.getField().getType() == Float.class
				|| field.getField().getType() == float.class) {
			statement.setFloat(index, (Float) value);
			return;
		}

		if (field.getField().getType() == Double.class
				|| field.getField().getType() == double.class) {
			statement.setBigDecimal(index, BigDecimal.valueOf(((Double) value)
					.doubleValue()));
			return;
		}

		if (field.getField().getType() == BigDecimal.class) {
			statement.setBigDecimal(index, (BigDecimal) value);
			return;
		}

		statement.setBigDecimal(index, new BigDecimal(String.valueOf(value)));

	}

	@Override
	protected void setPrepareStatementDefaultValue(PreparedStatement statement,
			FieldColumn field, int index, String value) throws SQLException {
		statement.setBigDecimal(index, new BigDecimal(String.valueOf(value)));

	}

}
