package com.rapid.j2ee.framework.orm.medium.statement;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.Date;

import com.rapid.j2ee.framework.core.utils.DateTimeUtils;
import com.rapid.j2ee.framework.core.utils.support.DateTimeFormat;
import com.rapid.j2ee.framework.orm.medium.field.FieldColumn;

public class DateInPreparedStatementAcceptor extends
		AbstractInPreparedStatementAcceptor {

	@Override
	protected void setPrepareStatementValue(PreparedStatement statement,
			FieldColumn field, int index, Object value) throws SQLException {

		if (field.getField().getType() == java.sql.Date.class) {
			statement.setDate(index, (java.sql.Date) value);
			return;
		}

		if (field.getField().getType() == Date.class) {
			statement.setDate(index, DateTimeUtils.toSqlDate((Date) value));
			return;
		}

		Date date = null;

		if (field.getField().getType() == Date.class) {

			date = (Date) value;
		} else {

			try {
				date = DateTimeFormat.getDateTimeFormat(field.getDateFormat())
						.getSimpleDateFormat().parse(String.valueOf(value));
			} catch (ParseException e) {
				throw new SQLException("Convert Date Error! Date Value:"
						+ value + " Format:" + field.getDateFormat());
			}
		}

		statement.setDate(index, DateTimeUtils.toSqlDate(date));

	}

	@Override
	protected void setPrepareStatementDefaultValue(PreparedStatement statement,
			FieldColumn field, int index, String value) throws SQLException {

		if ("systemdate".equalsIgnoreCase(value)
				|| "sysdate".equalsIgnoreCase(value)) {

			statement.setDate(index, new java.sql.Date(System
					.currentTimeMillis()));
			return;
		}

		try {
			Date date = DateTimeFormat.getDateTimeFormat(field.getDateFormat())
					.getSimpleDateFormat().parse(value);

			statement.setDate(index, DateTimeUtils.toSqlDate(date));

		} catch (ParseException e) {
			throw new SQLException("Convert Date Error! Date Value:" + value
					+ " Format:" + field.getDateFormat());
		}

	}
}
