package com.rapid.j2ee.framework.orm.medium.statement;

import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.SQLException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.rapid.j2ee.framework.orm.medium.field.FieldColumn;


public class FloatInPreparedStatementAcceptor extends
		AbstractInPreparedStatementAcceptor {

	private static final Log LOGGER = LogFactory
			.getLog(FloatInPreparedStatementAcceptor.class);

	@Override
	protected void setPrepareStatementValue(PreparedStatement statement,
			FieldColumn field, int index, Object value) throws SQLException {

		LOGGER.info("Index " + index + " Value:" + value);

		if (field.getField().getType() == int.class
				|| field.getField().getType() == Integer.class) {
			statement.setInt(index, (Integer) value);
			return;
		}

		if (field.getField().getType() == long.class
				|| field.getField().getType() == Long.class) {
			statement.setFloat(index, ((Long) value).floatValue());
			return;
		}

		if (field.getField().getType() == double.class
				|| field.getField().getType() == Double.class) {

			statement.setFloat(index, ((Double) value).floatValue());
			return;
		}

		if (field.getField().getType() == BigDecimal.class
				|| field.getField().getType() == BigDecimal.class) {

			statement.setFloat(index, ((BigDecimal) value).floatValue());
			return;
		}

		statement.setFloat(index, new Float(String.valueOf(value)));

	}

	@Override
	protected void setPrepareStatementDefaultValue(PreparedStatement statement,
			FieldColumn field, int index, String value) throws SQLException {
		statement.setFloat(index, new Float(String.valueOf(value)));

	}

}
