package com.rapid.j2ee.framework.orm.medium.statement;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;

import oracle.jdbc.driver.OraclePreparedStatement;

import org.apache.commons.dbcp.DelegatingStatement;

import com.rapid.j2ee.framework.core.utils.StringUtils;
import com.rapid.j2ee.framework.orm.medium.field.FieldColumn;

public class OracleNStringInPreparedStatementAcceptor extends
		AbstractInPreparedStatementAcceptor {

	@Override
	protected void setPrepareStatementValue(PreparedStatement statement,
			FieldColumn field, int index, Object value) throws SQLException {

		statement.setString(index, StringUtils.trimToEmpty(String
				.valueOf(value)));

	}

	@Override
	protected void setNVarchar(PreparedStatement statement, int index) {

		Statement delegate = statement;

		while (delegate instanceof DelegatingStatement) {
			delegate = ((DelegatingStatement) delegate).getDelegate();
		}

		if (delegate instanceof OraclePreparedStatement) {
			((OraclePreparedStatement) delegate).setFormOfUse(index,
					OraclePreparedStatement.FORM_NCHAR);

		}
	}

	protected boolean setNull(PreparedStatement statement, FieldColumn field,
			int index, Object value) throws SQLException {

		if (isNull(field, value)) {

			statement.setString(index, null);

			return true;
		}

		return false;
	}

	@Override
	protected void setPrepareStatementDefaultValue(PreparedStatement statement,
			FieldColumn field, int index, String value) throws SQLException {

		statement.setNString(index, value);

	}

}
