package com.rapid.j2ee.framework.orm.medium.statement;

import java.sql.PreparedStatement;
import java.sql.SQLException;

import com.rapid.j2ee.framework.core.utils.StringUtils;
import com.rapid.j2ee.framework.orm.medium.field.FieldColumn;

public class StringInPreparedStatementAcceptor extends
		AbstractInPreparedStatementAcceptor {



	@Override
	protected void setPrepareStatementValue(PreparedStatement statement,
			FieldColumn field, int index, Object value) throws SQLException {

		

		statement.setString(index, StringUtils.trimToEmpty(String
				.valueOf(value)));

	}

	@Override
	protected void setPrepareStatementDefaultValue(PreparedStatement statement,
			FieldColumn field, int index, String value) throws SQLException {
		statement.setString(index, value);

	}

}
