package com.rapid.j2ee.framework.orm.medium.statement;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.Date;

import com.rapid.j2ee.framework.core.utils.DateTimeUtils;
import com.rapid.j2ee.framework.core.utils.support.DateTimeFormat;
import com.rapid.j2ee.framework.orm.medium.field.FieldColumn;

public class TimestampInPreparedStatementAcceptor extends
		AbstractInPreparedStatementAcceptor {

	@Override
	protected void setPrepareStatementValue(PreparedStatement statement,
			FieldColumn field, int index, Object value) throws SQLException {

		if (field.getField().getType() == Timestamp.class) {
			statement.setTimestamp(index, (Timestamp) value);
			return;
		}

		Date date = null;

		if (field.getField().getType() == Date.class) {

			date = (Date) value;
		} else {

			try {
				date = DateTimeFormat.getDateTimeFormat(field.getDateFormat())
						.getSimpleDateFormat().parse(String.valueOf(value));
			} catch (ParseException e) {
				throw new SQLException("Convert Date Error! Date Value:"
						+ value + " Format:" + field.getDateFormat());
			}
		}

		statement.setTimestamp(index, DateTimeUtils.toSqlTimestamp(date));

	}

	@Override
	protected void setPrepareStatementDefaultValue(PreparedStatement statement,
			FieldColumn field, int index, String value) throws SQLException {

		if ("systemdate".equalsIgnoreCase(value)
				|| "sysdate".equalsIgnoreCase(value)) {

			statement.setTimestamp(index, new Timestamp(System
					.currentTimeMillis()));
			return;
		}

		Date date;
		try {
			date = DateTimeFormat.getDateTimeFormat(field.getDateFormat())
					.getSimpleDateFormat().parse(value);
		} catch (ParseException e) {
			throw new SQLException("Convert Date Error! Date Value:" + value
					+ " Format:" + field.getDateFormat());
		}

		statement.setTimestamp(index, DateTimeUtils.toSqlTimestamp(date));
	}
}
