package com.rapid.j2ee.framework.orm.medium.table;

import java.sql.Types;

public class DefaultTableColumnTypeMapper implements TableColumnTypeMapper {

	public TableColumnType getTypeName(int type, String rsTypeName) {

		if (Types.CHAR == type || Types.VARCHAR == type
				|| Types.LONGVARCHAR == type) {
			return new TableColumnType(type, rsTypeName, "STRING", "STRING");
		}

		if (Types.NCHAR == type || Types.NVARCHAR == type
				|| Types.LONGVARCHAR == type) {
			return new TableColumnType(type, rsTypeName, "NSTRING", "NSTRING");
		}

		if (Types.BIGINT == type || Types.BIT == type || Types.TINYINT == type
				|| Types.SMALLINT == type || Types.INTEGER == type) {
			return new TableColumnType(type, rsTypeName, "INTEGER", "INTEGER");
		}

		if (Types.LONGVARCHAR == type) {
			return new TableColumnType(type, rsTypeName, "LONG", "LONG");
		}

		if (Types.FLOAT == type) {
			return new TableColumnType(type, rsTypeName, "FLOAT", "FLOAT");
		}

		if (Types.REAL == type || Types.DOUBLE == type) {
			return new TableColumnType(type, rsTypeName, "DOUBLE", "DOUBLE");
		}

		if (Types.DOUBLE == type) {
			return new TableColumnType(type, rsTypeName, "DOUBLE", "DOUBLE");
		}

		if (Types.NUMERIC == type || Types.DECIMAL == type) {
			return new TableColumnType(type, rsTypeName, "BIGDECIMAL",
					"BIGDECIMAL");
		}

		if (Types.DATE == type) {
			return new TableColumnType(type, rsTypeName, "TIMESTAMP", "DATE");
		}

		if (Types.TIMESTAMP == type) {
			return new TableColumnType(type, rsTypeName, "TIMESTAMP",
					"TIMESTAMP");
		}

		if (Types.TIME == type) {
			return new TableColumnType(type, rsTypeName, "TIME", "TIME");
		}

		if (Types.BLOB == type) {
			return new TableColumnType(type, rsTypeName, "BLOB", "BLOB");
		}

		if (Types.LONGVARBINARY == type) {
			return new TableColumnType(type, rsTypeName, "BLOB", "BLOB");
		}
		
		if(Types.CLOB == type){
			return new TableColumnType(type, rsTypeName, "STRING", "STRING");
		}

		throw new IllegalArgumentException("java.sql.Types Type[" + type
				+ "] Name[" + rsTypeName + "]");

	}

}
