package com.rapid.j2ee.framework.orm.medium.table;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import com.rapid.j2ee.framework.core.io.xml.XPathTagBean;
import com.rapid.j2ee.framework.core.io.xml.XmlFieldAttribute;
import com.rapid.j2ee.framework.core.io.xml.XmlTag;
import com.rapid.j2ee.framework.core.utils.StringUtils;
import com.rapid.j2ee.framework.core.utils.TypeChecker;
@XmlTag
public class Table implements Serializable {

	private static final long serialVersionUID = 1L;
	@XmlFieldAttribute
	private String tableName;
	@XmlFieldAttribute
	private String schema;

	@XmlFieldAttribute(tagAttributeName="Columns")
	@XPathTagBean("medium/table/columns/column")
	private List<TableColumn> tableColumns;

	public Table() {
	}
	public Table(String schema, String tableName) {
		this.tableName = tableName;
		this.schema = schema;
		this.tableColumns = new ArrayList<TableColumn>();
	}

	public boolean hasTableColumns() {
		return !TypeChecker.isEmpty(this.getTableColumns());
	}

	public List<TableColumn> getTableColumns() {
		return tableColumns;
	}

	public String getTableName() {
		return tableName;
	}

	public void addTableColumns(List<TableColumn> tableColumns) {
		this.tableColumns = tableColumns;
	}

	public String toString() {
		return "Table Name:" + this.tableName + " Table Columns:"
				+ this.tableColumns;
	}

	public String getSchema() {
		return schema;
	}

	public String getSchemaTable() {
		return TypeChecker.isEmpty(this.schema) ? this.tableName : this.schema
				+ "." + this.tableName;
	}

}
