package com.rapid.j2ee.framework.orm.medium.table;

import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

import com.rapid.j2ee.framework.core.io.xml.XPathTagBean;
import com.rapid.j2ee.framework.core.io.xml.XmlFieldAttribute;
import com.rapid.j2ee.framework.core.io.xml.XmlTag;
import com.rapid.j2ee.framework.core.utils.StringUtils;
import com.rapid.j2ee.framework.core.utils.TypeChecker;
import com.rapid.j2ee.framework.core.utils.support.EqualableTarget;

@XmlTag(tagName = "Column")
public class TableColumn implements Serializable, EqualableTarget<String> {

	private static final long serialVersionUID = 1L;

	@XmlFieldAttribute
	private String columnName;

	@XmlFieldAttribute
	private String primaryKey;

	@XmlFieldAttribute
	private String remarks;

	@XmlFieldAttribute
	@XPathTagBean("type")
	private TableColumnType columnType;

	public TableColumn() {
	}

	public TableColumn(String columnName) {
		this.columnName = columnName;
		this.columnType = TableColumnType.DEFAULT_TABLE_COLUMN_TYPE;

	}

	public TableColumn(TableColumnTypeMapper typeMapper, ResultSet rs,
			List<String> pks) throws SQLException {

		this.columnName = rs.getString("COLUMN_NAME");

		columnType = typeMapper.getTypeName(rs.getInt("DATA_TYPE"), rs
				.getString("TYPE_NAME"));

		remarks = rs.getString("REMARKS");

		this.primaryKey = String.valueOf(pks.contains(this.columnName));

	}

	public String getColumnName() {
		return columnName;
	}

	public boolean isPrimaryKey() {
		return TypeChecker.isTrue(primaryKey);
	}

	public TableColumnType getColumnType() {
		return columnType;
	}

	public String toString() {
		return "Column Name:" + this.columnName + " SQL Column Type:"
				+ columnType + " Primary Key:" + this.primaryKey;
	}

	public String getRemarks() {
		return remarks;
	}

	public boolean supportsLike() {
		return StringUtils.containsIgnoreCase("VARCHAR,VARCHAR2,CHAR,TEXT",
				this.columnType.getTypeName(), ",");
	}

	public boolean equalsObject(String fieldName, String target,
			String fieldValue) {

		return StringUtils.equalsIgnoreCase(target, fieldValue);
	}

}
