package com.rapid.j2ee.framework.orm.medium.table;

import com.rapid.j2ee.framework.core.io.xml.XmlFieldAttribute;
import com.rapid.j2ee.framework.core.io.xml.XmlTag;

@XmlTag(tagName="Type")
public class TableColumnType {

	public static final TableColumnType DEFAULT_TABLE_COLUMN_TYPE = new TableColumnType(
			-1, "Unkown", "Unkown", "Unkown");

	@XmlFieldAttribute
	private int sqlType;

	@XmlFieldAttribute
	private String inTypeName;

	@XmlFieldAttribute
	private String outTypeName;

	@XmlFieldAttribute
	private String typeName;

	public TableColumnType() {
	}

	public TableColumnType(int sqlType, String typeName, String inTypeName,
			String outTypeName) {
		this.sqlType = sqlType;
		this.inTypeName = inTypeName;
		this.outTypeName = outTypeName;
		this.typeName = typeName;
	}

	public String getInTypeName() {
		return inTypeName;
	}

	public String getOutTypeName() {
		return outTypeName;
	}

	public int getSqlType() {
		return sqlType;
	}

	public String getTypeName() {
		return typeName;
	}

	public String toString() {
		return "SQL Type:" + this.sqlType + " SQL Type Name:" + this.typeName
				+ " In Type Name:" + this.inTypeName + " Out Type Name:"
				+ this.outTypeName;
	}

}
