package com.rapid.j2ee.framework.orm.medium.table;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.DataSourceUtils;

import com.rapid.j2ee.framework.core.exception.ExceptionUtils;
import com.rapid.j2ee.framework.core.utils.StringUtils;
import com.rapid.j2ee.framework.core.utils.TypeChecker;
import com.rapid.j2ee.framework.orm.medium.table.xml.TableConfigureStorageAccessor;
import com.rapid.j2ee.framework.orm.medium.table.xml.TableConfigureXmlStorageAccessor;

public class TableConfigureJdbcTemplate extends JdbcTemplate {

	private static final String[] TABLE_TYPES = new String[] { "TABLE" };

	public Table getTable(Class tableClz, String catalog, String schema,
			String tableName, TableColumnTypeMapper typeMapper) {

		Table table = new Table(schema, tableName);

		table.addTableColumns(getTableColumns(catalog, schema, tableName,
				typeMapper));

		if (!table.hasTableColumns()) {

			table.addTableColumns(tableConfigureStorageAccessor
					.getTableColumns(tableClz));

			return table;
		}

		tableConfigureStorageAccessor.saveTableXml(tableClz, table);

		return table;

	}

	public String getTableOrmJavaSource(String catalog, String schema,
			String tableName, TableColumnTypeMapper typeMapper,
			String lineSeparator) {

		List<TableColumn> columns = getTableColumns(catalog, schema, tableName,
				typeMapper);

		StringBuffer sb = new StringBuffer(500);

		sb.append("public class " + tableName
				+ " implements java.io.Serializable {" + lineSeparator);

		for (TableColumn column : columns) {

			sb.append(lineSeparator);

			String[] fieldNames = StringUtils.splitBySeparator(column
					.getColumnName().toLowerCase(), "_");

			for (int i = 1; i < fieldNames.length; i++) {

				fieldNames[i] = String.valueOf(fieldNames[i].charAt(0))
						.toUpperCase()
						+ fieldNames[i].substring(1);
			}

			if (!TypeChecker.isEmpty(column.getRemarks())) {
				sb.append("/**" + lineSeparator);
				sb.append("*" + column.getRemarks() + lineSeparator);

				sb.append("**/" + lineSeparator);
			}

			sb.append("@Column" + lineSeparator);

			if (column.isPrimaryKey()) {
				sb.append("@ID" + lineSeparator);
			}

			sb.append(lineSeparator);

			sb.append(" private  "
					+ this.getJavaTypeByDatabaseColumnType(column) + " "
					+ StringUtils.getStringBunch(fieldNames, "") + ";");

			sb.append(lineSeparator);
		}

		sb.append("}" + lineSeparator);

		return sb.toString();

	}

	private String getJavaTypeByDatabaseColumnType(TableColumn column) {

		String columnType = column.getColumnType().getTypeName().toUpperCase();

		logger.info("Database Column Type:" + columnType + " Column:"
				+ column.getColumnName() + " Name:" + column.getRemarks());

		if (TypeChecker.isNull(columnTypeToJavaSourceTypeMapper)) {
			return "String";
		}

		return columnTypeToJavaSourceTypeMapper.containsKey(columnType) ? columnTypeToJavaSourceTypeMapper
				.getProperty(columnType)
				: "String";

	}

	public List<String> getPrimaryKeys(String catalog, String schema,
			String table) {

		List<String> columns = new ArrayList<String>(3);

		Connection conn = getConnection();

		try {

			ResultSet rs = conn.getMetaData().getPrimaryKeys(catalog, schema,
					table);

			for (; rs.next();) {

				columns.add(rs.getString("COLUMN_NAME"));

			}
			return columns;

		} catch (SQLException e) {
			throw ExceptionUtils.convertThrowableToBaseException(e);
		} finally {
			releaseConnection(conn);
		}
	}

	public List<TableColumn> getTableColumns(String catalog,
			String schemaPattern, String tableName,
			TableColumnTypeMapper typeMapper) {

		tableName = StringUtils.trimToEmpty(tableName);

		Connection conn = getConnection();

		List<TableColumn> columns = new ArrayList<TableColumn>();

		try {

			List<String> pks = getPrimaryKeys(catalog, schemaPattern, tableName);

			ResultSet rs = conn.getMetaData().getColumns(catalog,
					schemaPattern, tableName, null);

			for (TableColumn column = null; rs.next();) {

				column = new TableColumn(typeMapper, rs, pks);
				columns.add(column);

			}

			printResultSet(rs);

			return columns;

		} catch (SQLException e) {
			throw ExceptionUtils.convertThrowableToBaseException(e);
		} finally {
			releaseConnection(conn);
		}
	}

	private void printResultSet(ResultSet rs) {
		try {
			ResultSetMetaData rsmd = rs.getMetaData();

			for (; rs.next();) {

				for (int i = 1, j = rsmd.getColumnCount(); i <= j; i++) {
					System.out.print(rsmd.getColumnName(i) + ":"
							+ rs.getObject(i) + " | ");

				}

				System.out.println();
			}

		} catch (SQLException e) {

			throw ExceptionUtils.convertThrowableToBaseException(e);
		}

	}

	protected final Connection getConnection() {
		return DataSourceUtils.getConnection(getDataSource());
	}

	protected final void releaseConnection(Connection conn) {
		DataSourceUtils.releaseConnection(conn, getDataSource());
	}

	public void setColumnTypeToJavaSourceTypeMapper(
			Properties columnTypeToJavaSourceTypeMapper) {
		this.columnTypeToJavaSourceTypeMapper = columnTypeToJavaSourceTypeMapper;
	}

	public void setTableConfigureStorageAccessor(
			TableConfigureStorageAccessor tableConfigureStorageAccessor) {
		this.tableConfigureStorageAccessor = tableConfigureStorageAccessor;
	}

	private Properties columnTypeToJavaSourceTypeMapper = null;

	private TableConfigureStorageAccessor tableConfigureStorageAccessor = TableConfigureStorageAccessor.TableConfigureDefaultStorage_DoNothing;

	private Log logger = LogFactory.getLog(this.getClass());

}
