package com.rapid.j2ee.framework.orm.medium.table.xml;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.xpath.XPathResult;

import com.rapid.j2ee.framework.core.charset.Charsets;
import com.rapid.j2ee.framework.core.io.file.FileWriter;
import com.rapid.j2ee.framework.core.io.xml.XNode;
import com.rapid.j2ee.framework.core.io.xml.XPathParser;
import com.rapid.j2ee.framework.core.io.xml.XmlPaserJavaBean;
import com.rapid.j2ee.framework.core.io.xml.XmlWriteBuilder;
import com.rapid.j2ee.framework.core.io.xml.XmlWriter;
import com.rapid.j2ee.framework.core.utils.FileUtils;
import com.rapid.j2ee.framework.core.utils.ObjectUtils;
import com.rapid.j2ee.framework.core.utils.TypeChecker;
import com.rapid.j2ee.framework.orm.medium.table.Table;
import com.rapid.j2ee.framework.orm.medium.table.TableColumn;

public class TableConfigureXmlStorageAccessor implements
		TableConfigureStorageAccessor {

	public List<TableColumn> getTableColumns(Class clz) {

		try {

			XPathParser xPathParser = new XPathParser(FileUtils
					.getResourceAsStream(clz.getSimpleName()
							+ Table_Class_Medium_Xml_Name, clz));
			XNode node = xPathParser.evalNode("medium/table");
			XmlPaserJavaBean xmlReaderObject = new XmlPaserJavaBean(
					xPathParser, Table.class);

			Table table = (Table) xmlReaderObject.resolve();

			return table.getTableColumns();

		} catch (Exception e) {

			LOG.debug(e.getMessage());

			return ObjectUtils.EMPTY_LIST;
		}
	}

	public void saveTableXml(Class clz, Table table) {

		if (TypeChecker.isEmpty(this.xmlPath)) {
			LOG
					.warn("The Xml Storage Path is empty ! Xml Medium File cannot be saved auto!");
			return;
		}

		XmlWriter xmlWriter = new XmlWriter();

		XmlWriteBuilder xmlWriteBuilder = new XmlWriteBuilder(xmlWriter);

		xmlWriteBuilder.createRootElement(Xml_Root_Name);

		xmlWriteBuilder.addXmlItems(table);

		FileWriter fileWriter = new FileWriter(new File(this.xmlPath, clz
				.getSimpleName()
				+ Table_Class_Medium_Xml_Name), Charsets.UTF_8);

		try {
			fileWriter.write(xmlWriteBuilder.toXmlText());
		} finally {
			fileWriter.close();
		}
	}

	public void setStoreXmlPath(String xmlPath) {
		this.xmlPath = xmlPath;
	}

	private String xmlPath;

	private static final String Xml_Root_Name = "medium";

	private static final Logger LOG = LoggerFactory
			.getLogger(TableConfigureXmlStorageAccessor.class);

}
