package com.rapid.j2ee.framework.orm.mybatis.criteria.support;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import com.rapid.j2ee.framework.core.annoconverter.AnnotationTypeConverterFactory;
import com.rapid.j2ee.framework.core.exception.ExceptionUtils;
import com.rapid.j2ee.framework.core.pagination.Page;
import com.rapid.j2ee.framework.core.pagination.PageBound;
import com.rapid.j2ee.framework.core.pagination.PageConstants;
import com.rapid.j2ee.framework.core.reflect.invoker.MethodInvoker;
import com.rapid.j2ee.framework.core.spring.SpringApplicationContextHolder;
import com.rapid.j2ee.framework.core.utils.ClassUtils;
import com.rapid.j2ee.framework.core.utils.StringUtils;
import com.rapid.j2ee.framework.core.utils.TypeChecker;
import com.rapid.j2ee.framework.orm.mybatis.criteria.AbstractMybatisSearchCriteria;
import com.rapid.j2ee.framework.orm.mybatis.criteria.AbstractMybatisSearchPageCriteria;
import com.rapid.j2ee.framework.orm.mybatis.criteria.MybatisSearchParameterCriteria;
import com.rapid.j2ee.framework.orm.mybatis.pagination.PageResultContainer;
import com.rapid.j2ee.framework.orm.mybatis.result.OutputResultContainer;
import com.rapid.j2ee.framework.orm.mybatis.result.OutputResultMapContainer;

public class SearchCriteriaMapBuilder {

	private static Set<Class> Ignore_Class_Mapper = new HashSet<Class>(5);

	static {

		Ignore_Class_Mapper.add(AbstractMybatisSearchCriteria.class);
		Ignore_Class_Mapper.add(OutputResultMapContainer.class);
		Ignore_Class_Mapper.add(OutputResultContainer.class);

		Ignore_Class_Mapper.add(AbstractMybatisSearchPageCriteria.class);

		Ignore_Class_Mapper.add(MybatisSearchParameterCriteria.class);
		Ignore_Class_Mapper.add(PageResultContainer.class);
		Ignore_Class_Mapper.add(PageBound.class);
		Ignore_Class_Mapper.add(Page.class);

		// NOT_SEARCH_POJO_CLASSES.add(PageInfoContainer.class);
		// NOT_SEARCH_POJO_CLASSES.add(OutputResultMapContainer.class);
		// NOT_SEARCH_POJO_CLASSES.add(AbstractSearchContainerCriterion.class);

		// OutputResultMapContainer implements OutputResultContainer

	}

	public static Map<String, Object> build(
			MybatisSearchParameterCriteria criterion) {

		Map<String, Object> maps = new HashMap<String, Object>();

		appendClassFields(maps, criterion);

		appendClassMethodUnderSearchMethodAnnotation(maps, criterion);

		appendPage(maps, criterion);

		return maps;

	}

	private static void appendClassFields(Map<String, Object> maps,
			MybatisSearchParameterCriteria criterion) {

		List<MethodInvoker> invokers = ClassUtils.getGetInvokers(criterion
				.getClass(), Ignore_Class_Mapper);

		for (MethodInvoker invoker : invokers) {

			Object value;
			try {
				value = invoker.invoke(criterion, null);
			} catch (Exception e) {
				throw ExceptionUtils.convertThrowableToBaseException(e);
			}

			value = conveterByFieldAnnotation(invoker, value);

			maps.put(invoker.invokerName(), value);

		}
	}

	private static void appendClassMethodUnderSearchMethodAnnotation(
			Map<String, Object> maps, MybatisSearchParameterCriteria criterion) {

		Method[] methods = ClassUtils.getAllMethodsAsClassByAnnotation(
				criterion.getClass(), SearchMethod.class);

		for (Method method : methods) {

			if (!TypeChecker.isEmpty(method.getParameterTypes())) {
				System.out
						.println("Warning..... Ingore method with parameters as input! Method :"
								+ method.getName()
								+ " of class "
								+ criterion.getClass().getName());
				continue;
			}

			try {

				String methodName = StringUtils.trimToEmpty(method
						.getAnnotation(SearchMethod.class).value(), method
						.getName());

				if (methodName.toLowerCase().startsWith("get")) {
					methodName = methodName.substring(3);
				}

				maps.put(methodName, method.invoke(criterion, null));

			} catch (Exception e) {
				e.printStackTrace();
			}
		}
	}

	private static Object conveterByFieldAnnotation(MethodInvoker invoker,
			Object value) {

		Field f = invoker.getField();

		if (invoker.getType() == String.class && !TypeChecker.isNull(value)) {
			value = StringUtils.trimToEmpty((String) value);
		}

		AnnotationTypeConverterFactory annotationTypeConverterFactory = SpringApplicationContextHolder
				.getBean(AnnotationTypeConverterFactory.class);

		if (TypeChecker.isNull(f)) {
			return value;
		}

		for (Annotation annotation : f.getAnnotations()) {

			value = annotationTypeConverterFactory.convert(annotation, value);

		}

		return value;
	}

	private static void appendPage(Map<String, Object> maps,
			MybatisSearchParameterCriteria criterion) {

		if (criterion instanceof PageBound) {
			PageBound pageBound = (PageBound) criterion;
			maps.put(PageConstants.Start_Row_Name, pageBound.getBeginRow());
			maps.put(PageConstants.Begin_Row_Name, pageBound.getBeginRow());
			maps.put(PageConstants.End_Row_Name, pageBound.getEndRow());
		}

		if (criterion instanceof Page) {
			Page page = (Page) criterion;
			maps.put(PageConstants.Page_Size_Name, page.getPageSize());
			maps.put(PageConstants.Current_Page_Name, page.getCurrentPage());
		}
	}

}
